/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.mixin;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.config.option.IdleCondition;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_9919;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_9919.class})
public class FramerateLimitTrackerMixin {
    @Shadow
    @Final
    private class_315 field_52730;
    @Shadow
    @Final
    private class_310 field_52731;
    @Shadow
    private int field_52732;

    @Inject(method={"getFramerateLimit"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFramerateLimit(CallbackInfoReturnable<Integer> callbackInfo) {
        PowerState state = DynamicFPSMod.powerState();
        if (state != PowerState.FOCUSED) {
            callbackInfo.setReturnValue((Object)Math.max(this.getFramerateTarget(), 15));
        } else {
            IdleCondition condition = DynamicFPSConfig.INSTANCE.idle().condition();
            if (condition != IdleCondition.VANILLA) {
                if (this.isInLevel() || !DynamicFPSConfig.INSTANCE.uncapMenuFrameRate()) {
                    callbackInfo.setReturnValue((Object)this.field_52732);
                } else {
                    callbackInfo.setReturnValue((Object)this.getMenuFramerateLimit());
                }
            }
        }
    }

    @Inject(method={"getFramerateLimit"}, at={@At(value="CONSTANT", args={"intValue=60"})}, cancellable=true)
    private void getMenuFramerateLimit(CallbackInfoReturnable<Integer> callbackInfo) {
        int limit = this.getFramerateTarget();
        if (DynamicFPSMod.powerState() != PowerState.FOCUSED) {
            if (limit < 60) {
                callbackInfo.setReturnValue((Object)limit);
            }
        } else if (DynamicFPSConfig.INSTANCE.uncapMenuFrameRate()) {
            callbackInfo.setReturnValue((Object)this.getMenuFramerateLimit());
        }
    }

    @Unique
    private int getFramerateTarget() {
        return DynamicFPSMod.targetFrameRate();
    }

    @Unique
    private int getMenuFramerateLimit() {
        if (((Boolean)this.field_52730.method_42433().method_41753()).booleanValue()) {
            return 260;
        }
        return Math.min(this.field_52732, 250);
    }

    @Unique
    private boolean isInLevel() {
        return this.field_52731.field_1687 != null || this.field_52731.field_1755 == null && this.field_52731.method_18506() == null;
    }
}

