/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.reflection;

import com.bawnorton.mixinsquared.reflection.FieldReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.IExtensionRegistry;

public final class ExtensionsExtension {
    private final Extensions reference;
    private final FieldReference<List<IExtension>> extensionsField;
    private final FieldReference<Map<Class<? extends IExtension>, IExtension>> extensionMapField;

    public ExtensionsExtension(Extensions reference) {
        this.reference = reference;
        this.extensionsField = new FieldReference(reference.getClass(), "extensions");
        this.extensionMapField = new FieldReference(reference.getClass(), "extensionMap");
    }

    public static Optional<ExtensionsExtension> tryAs(IExtensionRegistry reference) {
        if (reference instanceof Extensions) {
            return Optional.of(new ExtensionsExtension((Extensions)reference));
        }
        return Optional.empty();
    }

    public List<IExtension> getExtensions() {
        return this.extensionsField.get(this.reference);
    }

    public Map<Class<? extends IExtension>, IExtension> getExtensionMap() {
        return this.extensionMapField.get(this.reference);
    }
}

