/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_161;
import net.minecraft.class_1860;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public abstract class FabricRecipeProvider
extends class_2446.class_10114 {
    protected final FabricDataOutput output;
    private final CompletableFuture<class_7225.class_7874> registriesFuture;

    public FabricRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super((class_7784)output, registriesFuture);
        this.output = output;
        this.registriesFuture = registriesFuture;
    }

    protected abstract class_2446 method_62766(class_7225.class_7874 var1, class_8790 var2);

    protected class_8790 withConditions(final class_8790 exporter, final ResourceCondition ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return new class_8790(){

            public void method_53819(class_5321<class_1860<?>> key, class_1860<?> recipe, @Nullable class_8779 advancementEntry) {
                FabricDataGenHelper.addConditions(recipe, conditions);
                exporter.method_53819(key, recipe, advancementEntry);
            }

            public class_161.class_162 method_53818() {
                return exporter.method_53818();
            }

            public void method_62738() {
            }
        };
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.registriesFuture.thenCompose(wrapperLookup -> {
            final HashSet generatedRecipes = Sets.newHashSet();
            ArrayList list = new ArrayList();
            class_2446 recipeGenerator = this.method_62766((class_7225.class_7874)wrapperLookup, new class_8790(){
                final /* synthetic */ class_7225.class_7874 val$wrapperLookup;
                final /* synthetic */ List val$list;
                final /* synthetic */ class_7403 val$writer;
                {
                    this.val$wrapperLookup = class_78742;
                    this.val$list = list;
                    this.val$writer = class_74032;
                }

                public void method_53819(class_5321<class_1860<?>> recipeKey, class_1860<?> recipe, @Nullable class_8779 advancement) {
                    class_2960 identifier = FabricRecipeProvider.this.getRecipeIdentifier(recipeKey.method_29177());
                    if (!generatedRecipes.add(identifier)) {
                        throw new IllegalStateException("Duplicate recipe " + String.valueOf(identifier));
                    }
                    class_6903 registryOps = this.val$wrapperLookup.method_57093((DynamicOps)JsonOps.INSTANCE);
                    JsonObject recipeJson = ((JsonElement)class_1860.field_47319.encodeStart((DynamicOps)registryOps, recipe).getOrThrow(IllegalStateException::new)).getAsJsonObject();
                    ResourceCondition[] conditions = FabricDataGenHelper.consumeConditions(recipe);
                    FabricDataGenHelper.addConditions(recipeJson, conditions);
                    class_7784.class_7489 recipesPathResolver = FabricRecipeProvider.this.output.method_60917(class_7924.field_52178);
                    class_7784.class_7489 advancementsPathResolver = FabricRecipeProvider.this.output.method_60917(class_7924.field_52177);
                    this.val$list.add(class_2405.method_10320((class_7403)this.val$writer, (JsonElement)recipeJson, (Path)recipesPathResolver.method_44107(identifier)));
                    if (advancement != null) {
                        JsonObject advancementJson = ((JsonElement)class_161.field_47179.encodeStart((DynamicOps)registryOps, (Object)advancement.comp_1920()).getOrThrow(IllegalStateException::new)).getAsJsonObject();
                        FabricDataGenHelper.addConditions(advancementJson, conditions);
                        this.val$list.add(class_2405.method_10320((class_7403)this.val$writer, (JsonElement)advancementJson, (Path)advancementsPathResolver.method_44107(FabricRecipeProvider.this.getRecipeIdentifier(advancement.comp_1919()))));
                    }
                }

                public class_161.class_162 method_53818() {
                    return class_161.class_162.method_51698().method_708(class_5797.field_39377);
                }

                public void method_62738() {
                }
            });
            recipeGenerator.method_10419();
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    protected class_2960 getRecipeIdentifier(class_2960 identifier) {
        return class_2960.method_60655((String)this.output.getModId(), (String)identifier.method_12832());
    }
}

