/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.arguments;

import eu.pb4.placeholders.api.arguments.SimpleArguments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_5462;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class StringArgs {
    private static final StringArgs EMPTY = new StringArgs("");
    private final List<String> ordered = new ArrayList<String>();
    private final Map<String, String> keyed = new HashMap<String, String>();
    private final Map<String, StringArgs> keyedMaps = new HashMap<String, StringArgs>();
    private final String input;
    private int currentOrdered = 0;

    private StringArgs(String input) {
        this.input = input;
    }

    public static StringArgs ordered(String input, char separator) {
        StringArgs args = new StringArgs(input);
        args.ordered.addAll(SimpleArguments.split(input, separator));
        return args;
    }

    public static StringArgs keyed(String input, char separator, char map) {
        return StringArgs.keyed(input, separator, map, true, SimpleArguments::isWrapCharacter);
    }

    public static StringArgs keyed(String input, char separator, char map, boolean hasMaps, class_5462 wrapCharacters) {
        StringArgs args = new StringArgs(input);
        StringArgs.keyDecomposition(input, 0, separator, map, wrapCharacters, hasMaps, '\u0000', (key, value) -> {
            if (key != null) {
                args.keyed.put((String)key, value != null ? SimpleArguments.unwrap(value, wrapCharacters) : "");
            }
        }, args.keyedMaps::put);
        return args;
    }

    public static StringArgs full(String input, char separator, char map) {
        return StringArgs.full(input, separator, map, true, SimpleArguments::isWrapCharacter);
    }

    public static StringArgs full(String input, char separator, char map, boolean hasMaps, class_5462 wrapCharacters) {
        StringArgs args = new StringArgs(input);
        StringArgs.keyDecomposition(input, 0, separator, map, wrapCharacters, hasMaps, '\u0000', (key, value) -> {
            if (key != null) {
                args.keyed.put((String)key, value != null ? SimpleArguments.unwrap(value, wrapCharacters) : "");
                if (value == null) {
                    args.ordered.add(SimpleArguments.unwrap(key, wrapCharacters));
                }
            }
        }, args.keyedMaps::put);
        return args;
    }

    private static int keyDecomposition(String input, int offset, char separator, char map, class_5462 isWrap, boolean hasMaps, char stopAt, BiConsumer<@Nullable String, @Nullable String> consumer, BiConsumer<String, StringArgs> mapConsumer) {
        int i;
        String key = null;
        String value = null;
        StringBuilder b = new StringBuilder();
        char wrap = '\u0000';
        for (i = offset; i < input.length(); ++i) {
            char chrN;
            char chr = input.charAt(i);
            char c = chrN = i != input.length() - 1 ? input.charAt(i + 1) : (char)'\u0000';
            if (chr == stopAt && wrap == '\u0000') break;
            if (key != null && b.isEmpty() && hasMaps && (chr == '{' || chr == '[') && wrap == '\u0000') {
                ArrayList ordered = new ArrayList();
                HashMap keyed = new HashMap();
                HashMap keyedMaps = new HashMap();
                int ti = StringArgs.keyDecomposition(input, i + 1, separator, map, isWrap, true, chr == '{' ? (char)'}' : ']', (keyx, valuex) -> {
                    if (keyx != null) {
                        keyed.put(keyx, valuex != null ? SimpleArguments.unwrap(valuex, isWrap) : "");
                        if (valuex == null) {
                            ordered.add(SimpleArguments.unwrap(keyx, isWrap));
                        }
                    }
                }, keyedMaps::put);
                if (ti == input.length()) {
                    b.append(chr);
                    continue;
                }
                StringArgs arg = new StringArgs(input.substring(i, ti));
                arg.ordered.addAll(ordered);
                arg.keyed.putAll(keyed);
                arg.keyedMaps.putAll(keyedMaps);
                mapConsumer.accept(key, arg);
                key = null;
                i = ti;
                continue;
            }
            if (chr == map && wrap == '\u0000' && key == null) {
                key = b.toString();
                b = new StringBuilder();
                continue;
            }
            if (chr == '\\' && chrN != '\u0000' || chrN != '\u0000' && chr == chrN && isWrap.test(chr)) {
                b.append(chrN);
                ++i;
                continue;
            }
            if (isWrap.test(chr) && (wrap == '\u0000' || wrap == chr)) {
                wrap = wrap == '\u0000' ? chr : (char)'\u0000';
                continue;
            }
            if (chr == separator && wrap == '\u0000') {
                if (b.isEmpty() && key == null) {
                    consumer.accept(null, null);
                    continue;
                }
                if (key == null) {
                    key = b.toString();
                } else {
                    value = b.toString();
                }
                consumer.accept(key, value);
                key = null;
                value = null;
                b = new StringBuilder();
                continue;
            }
            b.append(chr);
        }
        if (key != null) {
            consumer.accept(key, b.isEmpty() ? null : b.toString());
        } else if (!b.isEmpty()) {
            consumer.accept(b.toString(), null);
        }
        return i;
    }

    public static StringArgs empty() {
        return EMPTY;
    }

    public static StringArgs emptyNew() {
        return new StringArgs("");
    }

    public String input() {
        return this.input;
    }

    @Nullable
    public String get(String name) {
        return this.keyed.get(name);
    }

    @Nullable
    public StringArgs getNested(String name) {
        return this.keyedMaps.get(name);
    }

    public StringArgs getNestedOrEmpty(String name) {
        return this.keyedMaps.getOrDefault(name, EMPTY);
    }

    public String get(String name, String defaultValue) {
        return this.keyed.getOrDefault(name, defaultValue);
    }

    @Nullable
    public String get(String name, int id) {
        String x = this.keyed.get(name);
        if (x != null) {
            return x;
        }
        if (id < this.ordered.size()) {
            return this.ordered.get(id);
        }
        return null;
    }

    public String get(String name, int id, String defaultValue) {
        String x = this.get(name, id);
        return x != null ? x : defaultValue;
    }

    @Nullable
    public String getNext(String name) {
        String x = this.keyed.get(name);
        if (x != null) {
            return x;
        }
        if (this.currentOrdered < this.ordered.size()) {
            return this.ordered.get(this.currentOrdered++);
        }
        return null;
    }

    public String getNext(String name, String defaultValue) {
        String x = this.getNext(name);
        return x != null ? x : defaultValue;
    }

    public void ifPresent(String key, Consumer<String> valueConsumer) {
        String val = this.get(key);
        if (val != null) {
            valueConsumer.accept(val);
        }
    }

    public boolean contains(String key) {
        return this.keyed.containsKey(key);
    }

    public boolean isEmpty() {
        return this.keyed.isEmpty() && this.ordered.isEmpty();
    }

    public List<String> ordered() {
        return Collections.unmodifiableList(this.ordered);
    }

    public int size() {
        return Math.max(this.keyed.size(), this.ordered.size());
    }

    @ApiStatus.Internal
    public List<String> unsafeOrdered() {
        return this.ordered;
    }

    @ApiStatus.Internal
    public Map<String, String> unsafeKeyed() {
        return this.keyed;
    }

    @ApiStatus.Internal
    public Map<String, StringArgs> unsafeKeyedMap() {
        return this.keyedMaps;
    }

    public String toString() {
        return "StringArgs{ordered=" + String.valueOf(this.ordered) + ", keyed=" + String.valueOf(this.keyed) + ", keyedMaps=" + String.valueOf(this.keyedMaps) + "}";
    }
}

