/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.entity.luminance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.entity.luminance.ArrowItemDerivedLuminance;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EndermanLuminance;
import dev.lambdaurora.lambdynlights.api.entity.luminance.FallingBlockLuminance;
import dev.lambdaurora.lambdynlights.api.entity.luminance.ItemDerivedEntityLuminance;
import dev.lambdaurora.lambdynlights.api.entity.luminance.ItemEntityLuminance;
import dev.lambdaurora.lambdynlights.api.entity.luminance.ItemFrameLuminance;
import dev.lambdaurora.lambdynlights.api.entity.luminance.MinecartDisplayBlockLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_8104;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface EntityLuminance {
    public static final Codec<EntityLuminance> CODEC = Codec.withAlternative((Codec)Type.CODEC.dispatch(EntityLuminance::type, Type::codec), Value.DIRECT_CODEC);
    public static final Codec<List<EntityLuminance>> LIST_CODEC = Codec.withAlternative((Codec)CODEC.listOf(), (Codec)CODEC.xmap(List::of, List::getFirst));

    @NotNull
    public Type type();

    public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager var1, @NotNull class_1297 var2);

    public static @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity, @NotNull @NotNull List<@NotNull EntityLuminance> luminances) {
        int luminance = 0;
        for (EntityLuminance luminanceSource : luminances) {
            int value = luminanceSource.getLuminance(itemLightSourceManager, entity);
            if (value <= luminance) continue;
            luminance = value;
        }
        return luminance;
    }

    public record Type(class_2960 id, MapCodec<? extends EntityLuminance> codec) {
        private static final Map<class_2960, Type> TYPES = new Object2ObjectOpenHashMap();
        public static final Codec<Type> CODEC = class_2960.field_25139.flatXmap(name -> Optional.ofNullable(TYPES.get(name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element name:" + String.valueOf(name))), type -> DataResult.success((Object)type.id));
        public static final Type VALUE = Type.register("value", Value.CODEC);
        public static final Type ARROW_ITEM_DERIVED = Type.registerSimple("arrow/derived_from_self_item", (EntityLuminance)ArrowItemDerivedLuminance.INSTANCE);
        public static final Type ENDERMAN = Type.registerSimple("enderman", (EntityLuminance)EndermanLuminance.INSTANCE);
        public static final Type FALLING_BLOCK = Type.registerSimple("falling_block", (EntityLuminance)FallingBlockLuminance.INSTANCE);
        public static final Type ITEM = Type.register("item", ItemDerivedEntityLuminance.CODEC);
        public static final Type ITEM_ENTITY = Type.registerSimple("item_entity", (EntityLuminance)ItemEntityLuminance.INSTANCE);
        public static final Type ITEM_FRAME = Type.registerSimple("item_frame", (EntityLuminance)ItemFrameLuminance.INSTANCE);
        public static final Type MINECART_DISPLAY_BLOCK = Type.registerSimple("minecart/display_block", (EntityLuminance)MinecartDisplayBlockLuminance.INSTANCE);

        public static Type register(@NotNull class_2960 id, @NotNull MapCodec<? extends EntityLuminance> codec) {
            Type type = new Type(id, codec);
            TYPES.put(id, type);
            return type;
        }

        private static Type register(String name, MapCodec<? extends EntityLuminance> codec) {
            return Type.register(class_2960.method_60655((String)"lambdynlights", (String)name), codec);
        }

        public static Type registerSimple(@NotNull class_2960 id, @NotNull EntityLuminance singleton) {
            return Type.register(id, (MapCodec<? extends EntityLuminance>)MapCodec.unit((Object)singleton));
        }

        private static Type registerSimple(String name, EntityLuminance singleton) {
            return Type.registerSimple(class_2960.method_60655((String)"lambdynlights", (String)name), singleton);
        }
    }

    public record Value(@Range(from=0L, to=15L) int luminance) implements EntityLuminance
    {
        public static final Codec<Value> DIRECT_CODEC = class_8104.field_42262.xmap(Value::new, Value::luminance);
        public static final MapCodec<Value> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_8104.field_42262.fieldOf("value").forGetter(Value::luminance)).apply((Applicative)instance, Value::new));

        @Override
        @NotNull
        public Type type() {
            return Type.VALUE;
        }

        @Override
        public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity) {
            return this.luminance;
        }
    }
}

