/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.api.predicate.LightSourceLocationPredicate;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2040;
import net.minecraft.class_2050;
import net.minecraft.class_2102;
import net.minecraft.class_3735;
import net.minecraft.class_9350;
import org.jetbrains.annotations.Range;

public record EntityLightSource(EntityPredicate predicate, List<EntityLuminance> luminances) {
    public static final Codec<EntityLightSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.CODEC.fieldOf("match").forGetter(EntityLightSource::predicate), (App)EntityLuminance.LIST_CODEC.fieldOf("luminance").forGetter(EntityLightSource::luminances)).apply((Applicative)instance, EntityLightSource::new));

    public @Range(from=0L, to=15L) int getLuminance(ItemLightSourceManager itemLightSourceManager, class_1297 entity) {
        if (this.predicate.test(entity)) {
            return EntityLuminance.getLuminance(itemLightSourceManager, entity, this.luminances);
        }
        return 0;
    }

    public record EntityPredicate(Optional<class_2050> entityType, Optional<LightSourceLocationPredicate> located, Optional<class_2102> effects, Optional<class_2040> flags, Optional<class_3735> equipment, Optional<EntityPredicate> vehicle, Optional<EntityPredicate> passenger, Optional<class_9350> slots) {
        public static final Codec<EntityPredicate> CODEC = Codec.recursive((String)"EntityPredicate", codec -> RecordCodecBuilder.create(instance -> instance.group((App)class_2050.field_45749.optionalFieldOf("type").forGetter(EntityPredicate::entityType), (App)LightSourceLocationPredicate.CODEC.optionalFieldOf("location").forGetter(EntityPredicate::located), (App)class_2102.field_45764.optionalFieldOf("effects").forGetter(EntityPredicate::effects), (App)class_2040.field_45745.optionalFieldOf("flags").forGetter(EntityPredicate::flags), (App)class_3735.field_45744.optionalFieldOf("equipment").forGetter(EntityPredicate::equipment), (App)codec.optionalFieldOf("vehicle").forGetter(EntityPredicate::vehicle), (App)codec.optionalFieldOf("passenger").forGetter(EntityPredicate::passenger), (App)class_9350.field_49755.optionalFieldOf("slots").forGetter(EntityPredicate::slots)).apply((Applicative)instance, EntityPredicate::new)));

        public boolean test(class_1297 entity) {
            if (entity == null) {
                return false;
            }
            if (this.entityType.isPresent() && !this.entityType.get().method_8925(entity.method_5864())) {
                return false;
            }
            if (this.located.isPresent() && !this.located.get().matches(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321())) {
                return false;
            }
            if (this.effects.isPresent() && !this.effects.get().method_9062(entity)) {
                return false;
            }
            if (this.flags.isPresent() && !this.flags.get().method_8892(entity)) {
                return false;
            }
            if (this.equipment.isPresent() && !this.equipment.get().method_16226(entity)) {
                return false;
            }
            if (this.vehicle.isPresent() && !this.vehicle.get().test(entity.method_5854())) {
                return false;
            }
            if (this.passenger.isPresent() && entity.method_5685().stream().noneMatch(passenger -> this.passenger.get().test((class_1297)passenger))) {
                return false;
            }
            return this.slots.isEmpty() || this.slots.get().method_58119(entity);
        }
    }
}

