/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod.fabric;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.util.OptionalUtil;
import com.terraformersmc.modmenu.util.VersionUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.fabric.CustomValueUtil;
import com.terraformersmc.modmenu.util.mod.fabric.FabricIconHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.ModOrigin;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1043;
import net.minecraft.class_1074;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricMod
implements Mod {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | FabricMod");
    protected final ModContainer container;
    protected final ModMetadata metadata;
    protected final ModMenuData modMenuData;
    protected final Set<Mod.Badge> badges;
    protected final Map<String, String> links = new HashMap<String, String>();
    @Nullable
    protected UpdateChecker updateChecker = null;
    @Nullable
    protected UpdateInfo updateInfo = null;
    protected boolean defaultIconWarning = true;
    protected boolean allowsUpdateChecks = true;
    protected boolean childHasUpdate = false;

    public FabricMod(ModContainer modContainer, Set<String> modpackMods) {
        this.container = modContainer;
        this.metadata = modContainer.getMetadata();
        String id = this.metadata.getId();
        if ("minecraft".equals(id) || "java".equals(id)) {
            this.allowsUpdateChecks = false;
        }
        Optional<String> parentId = Optional.empty();
        ModMenuData.DummyParentData parentData = null;
        HashSet<String> badgeNames = new HashSet<String>();
        CustomValue modMenuValue = this.metadata.getCustomValue("modmenu");
        if (modMenuValue != null && modMenuValue.getType() == CustomValue.CvType.OBJECT) {
            CustomValue.CvObject modMenuObject = modMenuValue.getAsObject();
            CustomValue parentCv = modMenuObject.get("parent");
            if (parentCv != null) {
                if (parentCv.getType() == CustomValue.CvType.STRING) {
                    parentId = Optional.of(parentCv.getAsString());
                } else if (parentCv.getType() == CustomValue.CvType.OBJECT) {
                    try {
                        CustomValue.CvObject parentObj = parentCv.getAsObject();
                        parentId = CustomValueUtil.getString("id", parentObj);
                        parentData = new ModMenuData.DummyParentData(parentId.orElseThrow(() -> new RuntimeException("Parent object lacks an id")), CustomValueUtil.getString("name", parentObj), CustomValueUtil.getString("description", parentObj), CustomValueUtil.getString("icon", parentObj), CustomValueUtil.getStringSet("badges", parentObj).orElse(new HashSet()));
                        if (parentId.orElse("").equals(id)) {
                            parentId = Optional.empty();
                            parentData = null;
                            throw new RuntimeException("Mod declared itself as its own parent");
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.error("Error loading parent data from mod: " + id, t);
                    }
                }
            }
            badgeNames.addAll(CustomValueUtil.getStringSet("badges", modMenuObject).orElse(new HashSet()));
            this.links.putAll(CustomValueUtil.getStringMap("links", modMenuObject).orElse(new HashMap()));
            this.allowsUpdateChecks = CustomValueUtil.getBoolean("update_checker", modMenuObject).orElse(true);
        }
        this.modMenuData = new ModMenuData(badgeNames, parentId, parentData, id);
        if (id.startsWith("fabric") && this.metadata.containsCustomValue("fabric-api:module-lifecycle")) {
            if (FabricLoader.getInstance().isModLoaded("fabric-api") || !FabricLoader.getInstance().isModLoaded("fabric")) {
                this.modMenuData.fillParentIfEmpty("fabric-api");
            } else {
                this.modMenuData.fillParentIfEmpty("fabric");
            }
            this.modMenuData.badges.add(Mod.Badge.LIBRARY);
        }
        if (id.startsWith("fabric") && (id.equals("fabricloader") || this.metadata.getProvides().contains("fabricloader") || id.equals("fabric") || id.equals("fabric-api") || this.metadata.getProvides().contains("fabric") || this.metadata.getProvides().contains("fabric-api") || id.equals("fabric-language-kotlin"))) {
            this.modMenuData.badges.add(Mod.Badge.LIBRARY);
        }
        this.badges = this.modMenuData.badges;
        if (this.metadata.getEnvironment() == ModEnvironment.CLIENT) {
            this.badges.add(Mod.Badge.CLIENT);
        }
        if (OptionalUtil.isPresentAndTrue(CustomValueUtil.getBoolean("fabric-loom:generated", this.metadata)) || "java".equals(id)) {
            this.badges.add(Mod.Badge.LIBRARY);
        }
        if ("deprecated".equals(CustomValueUtil.getString("fabric-api:module-lifecycle", this.metadata).orElse(null))) {
            this.badges.add(Mod.Badge.DEPRECATED);
        }
        if (this.metadata.containsCustomValue("patchwork:patcherMeta")) {
            this.badges.add(Mod.Badge.PATCHWORK_FORGE);
        }
        if (modpackMods.contains(this.getId()) && !"builtin".equals(this.metadata.getType())) {
            this.badges.add(Mod.Badge.MODPACK);
        }
        if ("minecraft".equals(this.getId())) {
            this.badges.add(Mod.Badge.MINECRAFT);
        }
    }

    @NotNull
    public ModContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public String getId() {
        return this.metadata.getId();
    }

    @Override
    @NotNull
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    @NotNull
    public class_1043 getIcon(FabricIconHandler iconHandler, int i) {
        String iconSourceId = this.getId();
        String iconPath = (String)((Object)this.metadata.getIconPath(i).orElse("assets/" + this.getId() + "/icon.png"));
        if ("minecraft".equals(this.getId())) {
            iconSourceId = "modmenu";
            iconPath = "assets/modmenu/minecraft_icon.png";
        } else if ("java".equals(this.getId())) {
            iconSourceId = "modmenu";
            iconPath = "assets/modmenu/java_icon.png";
        }
        String finalIconSourceId = iconSourceId;
        ModContainer iconSource = (ModContainer)FabricLoader.getInstance().getModContainer(iconSourceId).orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Fabric mod with id " + finalIconSourceId));
        class_1043 icon = iconHandler.createIcon(iconSource, iconPath);
        if (icon == null) {
            if (this.defaultIconWarning) {
                LOGGER.warn("Warning! Mod {} has a broken icon, loading default icon", (Object)this.metadata.getId());
                this.defaultIconWarning = false;
            }
            return iconHandler.createIcon((ModContainer)FabricLoader.getInstance().getModContainer("modmenu").orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Fabric mod with id modmenu")), "assets/modmenu/unknown_icon.png");
        }
        return icon;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.metadata.getDescription();
    }

    @Override
    @NotNull
    public String getTranslatedDescription() {
        Object description = Mod.super.getTranslatedDescription();
        if (this.getId().equals("java")) {
            description = (String)description + "\n" + class_1074.method_4662((String)"modmenu.javaDistributionName", (Object[])new Object[]{this.getName()});
        }
        return description;
    }

    @Override
    @NotNull
    public String getVersion() {
        if ("java".equals(this.getId())) {
            return System.getProperty("java.version");
        }
        return this.metadata.getVersion().getFriendlyString();
    }

    @Override
    @NotNull
    public String getPrefixedVersion() {
        return VersionUtil.getPrefixedVersion(this.getVersion());
    }

    @Override
    @NotNull
    public List<String> getAuthors() {
        List<String> authors = this.metadata.getAuthors().stream().map(Person::getName).collect(Collectors.toList());
        if (authors.isEmpty()) {
            if ("minecraft".equals(this.getId())) {
                return Lists.newArrayList((Object[])new String[]{"Mojang Studios"});
            }
            if ("java".equals(this.getId())) {
                return Lists.newArrayList((Object[])new String[]{System.getProperty("java.vendor")});
            }
        }
        return authors;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getContributors() {
        LinkedHashMap<String, Collection<String>> contributors = new LinkedHashMap<String, Collection<String>>();
        for (Person contributor : this.metadata.getContributors()) {
            contributors.put(contributor.getName(), List.of("Contributor"));
        }
        return contributors;
    }

    @Override
    @NotNull
    public SortedMap<String, Set<String>> getCredits() {
        TreeMap<String, Set<String>> credits = new TreeMap<String, Set<String>>();
        List<String> authors = this.getAuthors();
        Map<String, Collection<String>> contributors = this.getContributors();
        for (String string : authors) {
            contributors.put(string, List.of("Author"));
        }
        for (Map.Entry entry : contributors.entrySet()) {
            for (String role : (Collection)entry.getValue()) {
                credits.computeIfAbsent(role, key -> new LinkedHashSet());
                ((Set)credits.get(role)).add((String)entry.getKey());
            }
        }
        return credits;
    }

    @Override
    @NotNull
    public Set<Mod.Badge> getBadges() {
        return this.badges;
    }

    @Override
    @Nullable
    public String getWebsite() {
        if ("minecraft".equals(this.getId())) {
            return "https://www.minecraft.net/";
        }
        if ("java".equals(this.getId())) {
            return System.getProperty("java.vendor.url");
        }
        return this.metadata.getContact().get("homepage").orElse(null);
    }

    @Override
    @Nullable
    public String getIssueTracker() {
        if ("minecraft".equals(this.getId())) {
            return "https://aka.ms/snapshotbugs?ref=game";
        }
        return this.metadata.getContact().get("issues").orElse(null);
    }

    @Override
    @Nullable
    public String getSource() {
        return this.metadata.getContact().get("sources").orElse(null);
    }

    @Override
    @Nullable
    public String getParent() {
        return this.modMenuData.parent.orElse(null);
    }

    @Override
    @NotNull
    public Set<String> getLicense() {
        if ("minecraft".equals(this.getId())) {
            return Sets.newHashSet((Object[])new String[]{"Minecraft EULA"});
        }
        return Sets.newHashSet((Iterable)this.metadata.getLicense());
    }

    @Override
    @NotNull
    public Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public boolean allowsUpdateChecks() {
        if (ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(this.getId())) {
            return false;
        }
        return this.allowsUpdateChecks;
    }

    @Override
    @Nullable
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Override
    public void setUpdateChecker(@Nullable UpdateChecker updateChecker) {
        this.updateChecker = updateChecker;
    }

    @Override
    @Nullable
    public UpdateInfo getUpdateInfo() {
        return this.updateInfo;
    }

    @Override
    public void setUpdateInfo(@Nullable UpdateInfo updateInfo) {
        this.updateInfo = updateInfo;
        String parent = this.getParent();
        if (parent != null && updateInfo != null && updateInfo.isUpdateAvailable()) {
            ModMenu.MODS.get(parent).setChildHasUpdate();
        }
    }

    public ModMenuData getModMenuData() {
        return this.modMenuData;
    }

    @Override
    @Nullable
    public String getSha512Hash() throws IOException {
        File file;
        List paths;
        Optional<Path> fileOptional;
        if (this.container.getContainingMod().isEmpty() && this.container.getOrigin().getKind() == ModOrigin.Kind.PATH && (fileOptional = (paths = this.container.getOrigin().getPaths()).stream().filter(path -> path.toString().toLowerCase(Locale.ROOT).endsWith(".jar")).findFirst()).isPresent() && (file = fileOptional.get().toFile()).isFile()) {
            return Files.asByteSource((File)file).hash(Hashing.sha512()).toString();
        }
        return null;
    }

    @Override
    public boolean getChildHasUpdate() {
        return this.childHasUpdate;
    }

    @Override
    public void setChildHasUpdate() {
        this.childHasUpdate = true;
    }

    @Override
    public boolean isHidden() {
        return ModMenuConfig.HIDDEN_MODS.getValue().contains(this.getId());
    }

    static class ModMenuData {
        private final Set<Mod.Badge> badges;
        private Optional<String> parent;
        @Nullable
        private final DummyParentData dummyParentData;

        public ModMenuData(Set<String> badges, Optional<String> parent, DummyParentData dummyParentData, String id) {
            this.badges = Mod.Badge.convert(badges, id);
            this.parent = parent;
            this.dummyParentData = dummyParentData;
        }

        public Set<Mod.Badge> getBadges() {
            return this.badges;
        }

        public Optional<String> getParent() {
            return this.parent;
        }

        @Nullable
        public DummyParentData getDummyParentData() {
            return this.dummyParentData;
        }

        public void addClientBadge(boolean add) {
            if (add) {
                this.badges.add(Mod.Badge.CLIENT);
            }
        }

        public void addLibraryBadge(boolean add) {
            if (add) {
                this.badges.add(Mod.Badge.LIBRARY);
            }
        }

        public void fillParentIfEmpty(String parent) {
            if (!this.parent.isPresent()) {
                this.parent = Optional.of(parent);
            }
        }

        public static class DummyParentData {
            private final String id;
            private final Optional<String> name;
            private final Optional<String> description;
            private final Optional<String> icon;
            private final Set<Mod.Badge> badges;

            public DummyParentData(String id, Optional<String> name, Optional<String> description, Optional<String> icon, Set<String> badges) {
                this.id = id;
                this.name = name;
                this.description = description;
                this.icon = icon;
                this.badges = Mod.Badge.convert(badges, id);
            }

            public String getId() {
                return this.id;
            }

            public Optional<String> getName() {
                return this.name;
            }

            public Optional<String> getDescription() {
                return this.description;
            }

            public Optional<String> getIcon() {
                return this.icon;
            }

            public Set<Mod.Badge> getBadges() {
                return this.badges;
            }
        }
    }
}

