/*
 * Decompiled with CFR 0.152.
 */
package net.platinumdigitalgroup.jvdf;

import java.util.Map;
import java.util.Set;
import net.platinumdigitalgroup.jvdf.VDFNode;

public class VDFWriter {
    public String write(VDFNode root) {
        return this.write(root, false);
    }

    public String write(VDFNode root, boolean newLineOnNode) {
        return this.write(root, new StringBuilder(), new StringBuilder(), newLineOnNode);
    }

    private String write(VDFNode root, StringBuilder whitespace, StringBuilder builder, boolean newLineOnNode) {
        Set entries = root.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object[] value = (Object[])entry.getValue();
            for (int i = 0; i < value.length; ++i) {
                builder.append((CharSequence)whitespace);
                builder.append("\"").append(key).append("\"");
                builder.append(" ");
                Object obj = value[i];
                if (!(obj instanceof VDFNode)) {
                    builder.append("\"").append(obj).append("\"");
                } else {
                    VDFNode node = (VDFNode)obj;
                    if (newLineOnNode) {
                        builder.append("\n");
                        builder.append((CharSequence)whitespace);
                    }
                    builder.append("{\n");
                    whitespace.append("    ");
                    this.write(node, whitespace, builder, newLineOnNode);
                    whitespace.setLength(whitespace.length() - 4);
                    builder.append((CharSequence)whitespace);
                    builder.append("}");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }
}

