/*
 * Decompiled with CFR 0.152.
 */
package net.platinumdigitalgroup.jvdf;

import java.util.stream.IntStream;

public class VDFPreprocessor {
    public String process(String vdf) {
        return this.process(vdf.split("\\n"));
    }

    public String process(String[] lines) {
        this.processLines(lines);
        StringBuilder builder = new StringBuilder(lines.length * 20);
        int linesLength = lines.length;
        for (int i = 0; i < linesLength; ++i) {
            String s = lines[i];
            if (s == null || s.length() <= 0) continue;
            builder.append(s);
            if (i >= linesLength - 1) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    public void processLines(String[] lines) {
        IntStream.range(0, lines.length).parallel().forEach(i -> {
            lines[i] = this.processLine(lines[i]);
        });
    }

    public String processLine(String line) {
        StringBuilder sb = new StringBuilder(line.length());
        char[] charArray = line.toCharArray();
        if (charArray.length >= 2 && this.isComment(charArray, 0)) {
            return null;
        }
        boolean hitWord = false;
        boolean openQuotes = false;
        int charArrayLength = charArray.length;
        for (int i = 0; i < charArrayLength; ++i) {
            boolean hasPrevious;
            char c = charArray[i];
            char n = '\u0000';
            char p = '\u0000';
            boolean hasNext = i < charArrayLength - 1;
            boolean bl = hasPrevious = i > 0;
            if (c == '\n' || c == '\r') continue;
            if (hasPrevious) {
                p = charArray[i - 1];
            }
            if (c == '\"' && !hasPrevious || hasPrevious && c == '\"' && p != '\\') {
                boolean bl2 = openQuotes = !openQuotes;
            }
            if (hasNext) {
                n = charArray[i + 1];
                if (!openQuotes && this.isComment(charArray, i)) {
                    return sb.toString();
                }
            }
            if (!openQuotes && c == '[') {
                return sb.toString();
            }
            if (this.isWhitespace(c)) {
                if (!hitWord || hasNext && this.isWhitespace(n)) continue;
                boolean brk = false;
                for (int j = i; j < charArrayLength && this.isWhitespace(charArray[j]); ++j) {
                    if (j != charArrayLength - 1) continue;
                    brk = true;
                }
                if (brk) break;
                sb.append(' ');
                continue;
            }
            hitWord = true;
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean isComment(char[] arr, int index) {
        char f = arr[index];
        char s = arr[index + 1];
        return f == '/' && (s == '*' || s == '/');
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\u000b';
    }
}

