/*
 * Decompiled with CFR 0.152.
 */
package net.platinumdigitalgroup.jvdf;

import java.util.Stack;
import net.platinumdigitalgroup.jvdf.VDFNode;
import net.platinumdigitalgroup.jvdf.VDFParseException;

public class VDFParserState {
    private final VDFNode rootNode;
    private final Stack<VDFNode> childStack = new Stack();
    private boolean quoteState = false;
    private boolean escapePending = false;
    private boolean valuePending = false;
    private boolean nullString = false;
    private String keyName = "";
    private final StringBuilder currentString = new StringBuilder();

    public VDFParserState(VDFNode root) {
        this.rootNode = root;
        this.childStack.push(root);
    }

    public VDFParserState() {
        this(new VDFNode());
    }

    public VDFNode root() {
        return this.rootNode;
    }

    public VDFNode current() {
        return this.childStack.peek();
    }

    public void quote() {
        if (this.escapePending) {
            this.character('\"');
        } else {
            boolean bl = this.quoteState = !this.quoteState;
            if (this.quoteState) {
                this.resetString();
            } else {
                if (this.currentString.length() == 0) {
                    this.nullString = true;
                }
                this.space();
            }
        }
    }

    public void space() {
        if (this.quoteState) {
            this.character(' ');
        } else {
            if (this.currentString.length() == 0 && !this.nullString) {
                return;
            }
            boolean bl = this.valuePending = !this.valuePending;
            if (this.valuePending) {
                this.keyName = this.currentString.toString();
            } else {
                this.currentValue(this.keyName, this.currentString.toString());
            }
            this.resetString();
        }
    }

    public void escape() {
        boolean bl = this.escapePending = !this.escapePending;
        if (!this.escapePending) {
            this.character('\\');
        }
    }

    public void character(char c) {
        if (this.escapePending && c == 'n') {
            c = (char)10;
        }
        this.currentString.append(c);
        this.escapePending = false;
    }

    public void beginSubNode() {
        if (this.escapePending || this.quoteState) {
            this.character('{');
        } else {
            VDFNode node = new VDFNode();
            this.currentValue(this.keyName, node);
            this.childStack.push(node);
            this.resetKV();
        }
    }

    public void endSubNode() {
        if (this.escapePending || this.quoteState) {
            this.character('}');
        } else {
            this.resetKV();
            if (this.rootNode == this.childStack.pop()) {
                throw new VDFParseException("The root node was popped. There was a subnode mismatch (misplaced '}'?).");
            }
        }
    }

    public void endParse() {
        this.space();
        if (this.childStack.peek() != this.rootNode) {
            throw new VDFParseException("The root node was not at the top of the stack at the end of parsing. There was a subnode mismatch (misplaced '{'?)");
        }
    }

    private void currentValue(String key, Object val) {
        this.current().put(key, val);
    }

    private void resetString() {
        this.currentString.setLength(0);
        this.nullString = false;
    }

    private void resetKV() {
        this.resetString();
        this.valuePending = false;
    }
}

