/*
 * Decompiled with CFR 0.152.
 */
package net.platinumdigitalgroup.jvdf;

import net.platinumdigitalgroup.jvdf.VDFNode;
import net.platinumdigitalgroup.jvdf.VDFParserState;
import net.platinumdigitalgroup.jvdf.VDFPreprocessor;

public class VDFParser {
    private final VDFPreprocessor preprocessor;

    public VDFParser(VDFPreprocessor preprocessor) {
        this.preprocessor = preprocessor;
    }

    public VDFParser() {
        this(new VDFPreprocessor());
    }

    public VDFNode parse(String vdf) {
        return this.parse(vdf.split("\\n"));
    }

    public VDFNode parse(String[] vdf) {
        char[] arr;
        String processed = this.preprocessor.process(vdf);
        VDFParserState state = new VDFParserState();
        block7: for (char c : arr = processed.toCharArray()) {
            switch (c) {
                case '\"': {
                    state.quote();
                    continue block7;
                }
                case ' ': {
                    state.space();
                    continue block7;
                }
                case '\\': {
                    state.escape();
                    continue block7;
                }
                case '{': {
                    state.beginSubNode();
                    continue block7;
                }
                case '}': {
                    state.endSubNode();
                    continue block7;
                }
                default: {
                    state.character(c);
                }
            }
        }
        state.endParse();
        return state.root();
    }
}

