/*
 * Decompiled with CFR 0.152.
 */
package net.lostluma.battery.impl;

import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import net.lostluma.battery.api.Battery;
import net.lostluma.battery.api.Manager;
import net.lostluma.battery.api.exception.InvalidStateError;
import net.lostluma.battery.api.exception.LibraryLoadError;
import net.lostluma.battery.impl.BatteryImpl;
import net.lostluma.battery.impl.util.NativeUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ManagerImpl
implements Manager {
    private final long ptr;
    private boolean active;
    private final ReferenceQueue<Battery> queue;
    private final Map<PhantomReference<?>, Long> references;

    public ManagerImpl() throws IOException, LibraryLoadError {
        NativeUtil.load();
        this.ptr = ManagerImpl.create();
        this.active = true;
        this.queue = new ReferenceQueue();
        this.references = new IdentityHashMap();
    }

    boolean isActive() {
        return this.active;
    }

    @Override
    @NotNull
    public Collection<Battery> batteries() throws IOException, InvalidStateError {
        if (this.isActive()) {
            Reference<Battery> ref;
            BatteryImpl[] batteries = this.batteries0();
            while ((ref = this.queue.poll()) != null) {
                this.dropBattery(this.references.remove(ref));
            }
            for (BatteryImpl battery : batteries) {
                this.references.put(new PhantomReference<Battery>(battery, this.queue), battery.ptr);
            }
            return Arrays.asList(batteries);
        }
        throw new InvalidStateError("Manager can not be used after being closed!");
    }

    @Override
    public void close() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.drop(this.ptr);
        for (Map.Entry<PhantomReference<?>, Long> entry : this.references.entrySet()) {
            this.dropBattery(entry.getValue());
        }
    }

    private static native long create() throws IOException;

    private native BatteryImpl[] batteries0() throws IOException;

    private native void drop(long var1);

    private native void dropBattery(long var1);
}

