/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.parsers.json.gson;

import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Reader;
import org.quiltmc.parsers.json.FormatViolationException;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonToken;
import org.quiltmc.parsers.json.MalformedSyntaxException;
import org.quiltmc.parsers.json.ParseException;

public class GsonReader
extends com.google.gson.stream.JsonReader {
    private final JsonReader delegate;

    public GsonReader(JsonReader reader) {
        super(Reader.nullReader());
        this.delegate = reader;
    }

    public JsonReader getDelegate() {
        return this.delegate;
    }

    private <T> T rethrowGsonExceptions(DelegateFunction<T> func) throws IOException {
        try {
            return func.call();
        }
        catch (FormatViolationException | MalformedSyntaxException e) {
            throw new JsonSyntaxException(e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new JsonParseException(e.getMessage(), (Throwable)e);
        }
    }

    private void rethrowGsonExceptionsVoid(DelegateAction action) throws IOException {
        this.rethrowGsonExceptions(action);
    }

    public void beginArray() throws IOException {
        this.rethrowGsonExceptionsVoid(() -> ((JsonReader)this.delegate).beginArray());
    }

    public void endArray() throws IOException {
        this.rethrowGsonExceptionsVoid(() -> ((JsonReader)this.delegate).endArray());
    }

    public void beginObject() throws IOException {
        this.rethrowGsonExceptionsVoid(() -> ((JsonReader)this.delegate).beginObject());
    }

    public void endObject() throws IOException {
        this.rethrowGsonExceptionsVoid(() -> ((JsonReader)this.delegate).endObject());
    }

    public boolean hasNext() throws IOException {
        return this.rethrowGsonExceptions(() -> ((JsonReader)this.delegate).hasNext());
    }

    public com.google.gson.stream.JsonToken peek() throws IOException {
        JsonToken quiltToken = this.rethrowGsonExceptions(() -> ((JsonReader)this.delegate).peek());
        switch (quiltToken) {
            case BEGIN_ARRAY: {
                return com.google.gson.stream.JsonToken.BEGIN_ARRAY;
            }
            case END_ARRAY: {
                return com.google.gson.stream.JsonToken.END_ARRAY;
            }
            case BEGIN_OBJECT: {
                return com.google.gson.stream.JsonToken.BEGIN_OBJECT;
            }
            case END_OBJECT: {
                return com.google.gson.stream.JsonToken.END_OBJECT;
            }
            case NAME: {
                return com.google.gson.stream.JsonToken.NAME;
            }
            case STRING: {
                return com.google.gson.stream.JsonToken.STRING;
            }
            case NUMBER: {
                return com.google.gson.stream.JsonToken.NUMBER;
            }
            case BOOLEAN: {
                return com.google.gson.stream.JsonToken.BOOLEAN;
            }
            case NULL: {
                return com.google.gson.stream.JsonToken.NULL;
            }
            case END_DOCUMENT: {
                return com.google.gson.stream.JsonToken.END_DOCUMENT;
            }
        }
        throw new IllegalStateException("Delegate returned unrecognized token " + quiltToken);
    }

    public String nextName() throws IOException {
        return this.rethrowGsonExceptions(() -> ((JsonReader)this.delegate).nextName());
    }

    public String nextString() throws IOException {
        return this.rethrowGsonExceptions(() -> ((JsonReader)this.delegate).nextString());
    }

    public boolean nextBoolean() throws IOException {
        return this.rethrowGsonExceptions(() -> ((JsonReader)this.delegate).nextBoolean());
    }

    public void nextNull() throws IOException {
        this.rethrowGsonExceptionsVoid(() -> ((JsonReader)this.delegate).nextNull());
    }

    public double nextDouble() throws IOException {
        return this.rethrowGsonExceptions(() -> ((JsonReader)this.delegate).nextDouble());
    }

    public long nextLong() throws IOException {
        return this.rethrowGsonExceptions(() -> ((JsonReader)this.delegate).nextLong());
    }

    public int nextInt() throws IOException {
        return this.rethrowGsonExceptions(() -> ((JsonReader)this.delegate).nextInt());
    }

    public void close() throws IOException {
        this.delegate.close();
        super.close();
    }

    public void skipValue() throws IOException {
        this.rethrowGsonExceptionsVoid(() -> ((JsonReader)this.delegate).skipValue());
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String getPreviousPath() {
        return this.delegate.getPreviousPath();
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    @FunctionalInterface
    private static interface DelegateFunction<T> {
        public T call() throws IOException;
    }

    @FunctionalInterface
    private static interface DelegateAction
    extends DelegateFunction<Void> {
        public void run() throws IOException;

        @Override
        default public Void call() throws IOException {
            this.run();
            return null;
        }
    }
}

