/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.CommonPacketHandler;
import net.fabricmc.fabric.impl.networking.CommonRegisterPayload;
import net.fabricmc.fabric.impl.networking.GlobalReceiverRegistry;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.RegistrationPayload;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_7648;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChanneledNetworkAddon<H>
extends AbstractNetworkAddon<H>
implements PacketSender,
CommonPacketHandler {
    private static final int MAX_CHANNELS = Integer.getInteger("fabric.networking.maxChannels", 8192);
    private static final int MAX_CHANNEL_NAME_LENGTH = Math.max(Integer.getInteger("fabric.networking.maxChannelNameLength", 128), 128);
    protected final class_2535 connection;
    protected final GlobalReceiverRegistry<H> receiver;
    protected final Set<class_2960> sendableChannels;
    protected int commonVersion = -1;

    protected AbstractChanneledNetworkAddon(GlobalReceiverRegistry<H> receiver, class_2535 connection, String description) {
        super(receiver, description);
        this.connection = connection;
        this.receiver = receiver;
        this.sendableChannels = Collections.synchronizedSet(new HashSet());
    }

    protected void registerPendingChannels(ChannelInfoHolder holder, class_2539 state) {
        Collection<class_2960> pending = holder.fabric_getPendingChannelsNames(state);
        if (!pending.isEmpty()) {
            this.register(new ArrayList<class_2960>(pending));
            pending.clear();
        }
    }

    public boolean handle(class_8710 payload) {
        Object handler;
        class_2960 channelName = payload.method_56479().comp_2242();
        this.logger.debug("Handling inbound packet from channel with name \"{}\"", (Object)channelName);
        if (payload instanceof RegistrationPayload) {
            RegistrationPayload registrationPayload = (RegistrationPayload)payload;
            if (NetworkingImpl.REGISTER_CHANNEL.equals((Object)channelName)) {
                this.receiveRegistration(true, registrationPayload);
                return true;
            }
            if (NetworkingImpl.UNREGISTER_CHANNEL.equals((Object)channelName)) {
                this.receiveRegistration(false, registrationPayload);
                return true;
            }
        }
        if ((handler = this.getHandler(channelName)) == null) {
            return false;
        }
        try {
            this.receive(handler, payload);
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel with name \"{}\"", (Object)channelName, (Object)ex);
            throw ex;
        }
        return true;
    }

    protected abstract void receive(H var1, class_8710 var2);

    protected void sendInitialChannelRegistrationPacket() {
        RegistrationPayload payload = this.createRegistrationPayload(RegistrationPayload.REGISTER, this.getReceivableChannels());
        if (payload != null) {
            this.sendPacket(payload);
        }
    }

    @Nullable
    protected RegistrationPayload createRegistrationPayload(class_8710.class_9154<RegistrationPayload> id, Collection<class_2960> channels) {
        if (channels.isEmpty()) {
            return null;
        }
        return new RegistrationPayload(id, new ArrayList<class_2960>(channels));
    }

    protected void receiveRegistration(boolean register, RegistrationPayload payload) {
        if (register) {
            this.register(payload.channels());
        } else {
            this.unregister(payload.channels());
        }
    }

    void register(List<class_2960> ids) {
        ids.forEach(this::registerChannel);
        this.schedule(() -> this.invokeRegisterEvent(ids));
    }

    private void registerChannel(class_2960 id) {
        if (this.sendableChannels.size() >= MAX_CHANNELS) {
            throw new IllegalArgumentException("Cannot register more than " + MAX_CHANNELS + " channels");
        }
        if (id.toString().length() > MAX_CHANNEL_NAME_LENGTH) {
            throw new IllegalArgumentException("Channel name is too long");
        }
        this.sendableChannels.add(id);
    }

    void unregister(List<class_2960> ids) {
        this.sendableChannels.removeAll(ids);
        this.schedule(() -> this.invokeUnregisterEvent(ids));
    }

    @Override
    public void sendPacket(class_2596<?> packet, class_7648 callback) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.method_10752(packet, callback);
    }

    @Override
    public void disconnect(class_2561 disconnectReason) {
        Objects.requireNonNull(disconnectReason, "Disconnect reason cannot be null");
        this.connection.method_10747(disconnectReason);
    }

    protected abstract void schedule(Runnable var1);

    protected abstract void invokeRegisterEvent(List<class_2960> var1);

    protected abstract void invokeUnregisterEvent(List<class_2960> var1);

    public Set<class_2960> getSendableChannels() {
        return Collections.unmodifiableSet(this.sendableChannels);
    }

    @Override
    public void onCommonVersionPacket(int negotiatedVersion) {
        assert (negotiatedVersion == 1);
        this.commonVersion = negotiatedVersion;
        this.logger.debug("Negotiated common packet version {}", (Object)this.commonVersion);
    }

    @Override
    public void onCommonRegisterPacket(CommonRegisterPayload payload) {
        if (payload.version() != this.getNegotiatedVersion()) {
            throw new IllegalStateException("Negotiated common packet version: %d but received packet with version: %d".formatted(this.commonVersion, payload.version()));
        }
        String currentPhase = this.getPhase();
        if (currentPhase == null) {
            this.logger.warn("Received common register packet for phase {} in network state: {}", (Object)payload.phase(), (Object)this.receiver.getPhase());
            return;
        }
        if (!payload.phase().equals(currentPhase)) {
            throw new IllegalStateException("Register packet received for phase (%s) on handler for phase(%s)".formatted(payload.phase(), currentPhase));
        }
        this.register(new ArrayList<class_2960>(payload.channels()));
    }

    @Override
    public CommonRegisterPayload createRegisterPayload() {
        return new CommonRegisterPayload(this.getNegotiatedVersion(), this.getPhase(), this.getReceivableChannels());
    }

    @Override
    public int getNegotiatedVersion() {
        if (this.commonVersion == -1) {
            throw new IllegalStateException("Not yet negotiated common packet version");
        }
        return this.commonVersion;
    }

    @Nullable
    private String getPhase() {
        return switch (this.receiver.getPhase()) {
            case class_2539.field_20591 -> "play";
            case class_2539.field_45671 -> "configuration";
            default -> null;
        };
    }
}

