/*
 * Decompiled with CFR 0.152.
 */
package com.akuleshov7.ktoml.writers;

import com.akuleshov7.ktoml.TomlOutputConfig;
import com.akuleshov7.ktoml.tree.nodes.TableType;
import com.akuleshov7.ktoml.utils.KeysKt;
import com.akuleshov7.ktoml.utils.UtilsJvmKt;
import com.akuleshov7.ktoml.writers.IntegerRepresentation;
import com.akuleshov7.ktoml.writers.TomlEmitter;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0007H$J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015H$J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0000J\u0010\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\tJ\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0007J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00072\b\b\u0002\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\b\u0010$\u001a\u00020\u0000H\u0007J\b\u0010'\u001a\u00020\u0000H\u0007J\b\u0010(\u001a\u00020\u0000H\u0007J\b\u0010)\u001a\u00020\u0000H\u0007J\"\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00072\b\b\u0002\u0010\"\u001a\u00020\u001d2\b\b\u0002\u0010,\u001a\u00020\u001dJ\"\u0010*\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\tJ\u000e\u0010*\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\u000e\u0010*\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u001dJ\u000e\u0010*\u001a\u00020\u00002\u0006\u00105\u001a\u000206J\u000e\u0010*\u001a\u00020\u00002\u0006\u00107\u001a\u000208J\u000e\u0010*\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020\u0000J\u0006\u0010>\u001a\u00020\u0000J\u0006\u0010?\u001a\u00020\u0000J\u0006\u0010@\u001a\u00020\u0000J\u0006\u0010A\u001a\u00020\u0000J\u0006\u0010B\u001a\u00020\u0000J\u0006\u0010C\u001a\u00020\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@DX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006D"}, d2={"Lcom/akuleshov7/ktoml/writers/TomlEmitter;", "", "config", "Lcom/akuleshov7/ktoml/TomlOutputConfig;", "<init>", "(Lcom/akuleshov7/ktoml/TomlOutputConfig;)V", "indentation", "", "value", "", "indentDepth", "getIndentDepth$annotations", "()V", "getIndentDepth", "()I", "setIndentDepth", "(I)V", "indent", "dedent", "emit", "fragment", "", "emitNewLine", "emitIndent", "emitWhitespace", "count", "emitComment", "comment", "inline", "", "emitKey", "key", "emitBareKey", "emitQuotedKey", "isLiteral", "emitKeyDot", "startTableHeader", "tableType", "Lcom/akuleshov7/ktoml/tree/nodes/TableType;", "endTableHeader", "startTableArrayHeader", "endTableArrayHeader", "emitValue", "string", "isMultiline", "integer", "", "representation", "Lcom/akuleshov7/ktoml/writers/IntegerRepresentation;", "groupSize", "float", "", "boolean", "instant", "Lkotlinx/datetime/Instant;", "dateTime", "Lkotlinx/datetime/LocalDateTime;", "date", "Lkotlinx/datetime/LocalDate;", "time", "Lkotlinx/datetime/LocalTime;", "emitNullValue", "startArray", "endArray", "startInlineTable", "endInlineTable", "emitElementDelimiter", "emitPairDelimiter", "ktoml-core"})
@SourceDebugExtension(value={"SMAP\nTomlEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlEmitter.kt\ncom/akuleshov7/ktoml/writers/TomlEmitter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n1#2:392\n*E\n"})
public abstract class TomlEmitter {
    @NotNull
    private final String indentation;
    private int indentDepth;

    public TomlEmitter(@NotNull TomlOutputConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.indentation = config.getIndentation().getValue();
    }

    public final int getIndentDepth() {
        return this.indentDepth;
    }

    protected final void setIndentDepth(int n) {
        this.indentDepth = n;
    }

    public static /* synthetic */ void getIndentDepth$annotations() {
    }

    public final int indent() {
        ++this.indentDepth;
        return this.indentDepth;
    }

    public final int dedent() {
        this.indentDepth += -1;
        return this.indentDepth;
    }

    @NotNull
    protected abstract TomlEmitter emit(@NotNull String var1);

    @NotNull
    protected abstract TomlEmitter emit(char var1);

    @NotNull
    public final TomlEmitter emitNewLine() {
        return this.emit(UtilsJvmKt.newLineChar());
    }

    @NotNull
    public final TomlEmitter emitIndent() {
        int n = this.indentDepth;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            this.emit(this.indentation);
        }
        return this;
    }

    @NotNull
    public final TomlEmitter emitWhitespace(int count) {
        int n = 0;
        while (n < count) {
            int it = n++;
            boolean bl = false;
            this.emit(' ');
        }
        return this;
    }

    public static /* synthetic */ TomlEmitter emitWhitespace$default(TomlEmitter tomlEmitter, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: emitWhitespace");
        }
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return tomlEmitter.emitWhitespace(n);
    }

    @NotNull
    public final TomlEmitter emitComment(@NotNull String comment, boolean inline) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        return this.emit(inline ? " # " : "# ").emit(comment);
    }

    public static /* synthetic */ TomlEmitter emitComment$default(TomlEmitter tomlEmitter, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: emitComment");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return tomlEmitter.emitComment(string, bl);
    }

    @NotNull
    public final TomlEmitter emitKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return KeysKt.isBareKey(key) ? this.emitBareKey(key) : this.emitQuotedKey(key, KeysKt.isLiteralKeyCandidate(key));
    }

    @NotNull
    public final TomlEmitter emitBareKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.emit(key);
    }

    @NotNull
    public final TomlEmitter emitQuotedKey(@NotNull String key, boolean isLiteral) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return TomlEmitter.emitValue$default(this, key, isLiteral, false, 4, null);
    }

    public static /* synthetic */ TomlEmitter emitQuotedKey$default(TomlEmitter tomlEmitter, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: emitQuotedKey");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return tomlEmitter.emitQuotedKey(string, bl);
    }

    @NotNull
    public final TomlEmitter emitKeyDot() {
        return this.emit('.');
    }

    @NotNull
    public final TomlEmitter startTableHeader(@NotNull TableType tableType) {
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"tableType");
        return this.emit(tableType.getOpen$ktoml_core());
    }

    @NotNull
    public final TomlEmitter endTableHeader(@NotNull TableType tableType) {
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"tableType");
        return this.emit(tableType.getClose$ktoml_core());
    }

    @Deprecated(message="startTableHeader and startTableArrayHeader were merged; use startTableHeader(TableType.PRIMITIVE). Will be removed in next releases.", replaceWith=@ReplaceWith(expression="startTableHeader(TableType.PRIMITIVE)", imports={"com.akuleshov7.ktoml.tree.nodes.TableType"}))
    @NotNull
    public final TomlEmitter startTableHeader() {
        return this.startTableHeader(TableType.PRIMITIVE);
    }

    @Deprecated(message="endTableHeader and endTableArrayHeader were merged; use endTableHeader(TableType.PRIMITIVE). Will be removed in next releases.", replaceWith=@ReplaceWith(expression="endTableHeader(TableType.PRIMITIVE)", imports={"com.akuleshov7.ktoml.tree.nodes.TableType"}))
    @NotNull
    public final TomlEmitter endTableHeader() {
        return this.endTableHeader(TableType.PRIMITIVE);
    }

    @Deprecated(message="startTableHeader and startTableArrayHeader were merged; use startTableHeader(TableType.ARRAY). Will be removed in next releases.", replaceWith=@ReplaceWith(expression="startTableHeader(TableType.ARRAY)", imports={"import com.akuleshov7.ktoml.tree.nodes.TableType"}))
    @NotNull
    public final TomlEmitter startTableArrayHeader() {
        return this.startTableHeader(TableType.ARRAY);
    }

    @Deprecated(message="endTableHeader and endTableArrayHeader were merged; use endTableHeader(TableType.ARRAY). Will be removed in next releases.", replaceWith=@ReplaceWith(expression="endTableHeader(TableType.PRIMITIVE)", imports={"import com.akuleshov7.ktoml.tree.nodes.TableType"}))
    @NotNull
    public final TomlEmitter endTableArrayHeader() {
        return this.endTableHeader(TableType.ARRAY);
    }

    @NotNull
    public final TomlEmitter emitValue(@NotNull String string, boolean isLiteral, boolean isMultiline) {
        TomlEmitter tomlEmitter;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (isMultiline) {
            String quotes = isLiteral ? "'''" : "\"\"\"";
            tomlEmitter = this.emit(quotes).emitNewLine().emit(string).emitNewLine().emit(quotes);
        } else {
            char quote = isLiteral ? (char)'\'' : '\"';
            tomlEmitter = this.emit(quote).emit(string).emit(quote);
        }
        return tomlEmitter;
    }

    public static /* synthetic */ TomlEmitter emitValue$default(TomlEmitter tomlEmitter, String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: emitValue");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return tomlEmitter.emitValue(string, bl, bl2);
    }

    @NotNull
    public final TomlEmitter emitValue(long integer, @NotNull IntegerRepresentation representation, int groupSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)representation), (String)"representation");
        if (representation == IntegerRepresentation.GROUPED) {
            return this.emitValue(integer, IntegerRepresentation.DECIMAL, 3);
        }
        if (integer < 0L) {
            this.emit('-');
        }
        String string = Long.toString(integer, CharsKt.checkRadix((int)representation.getRadix()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        char[] cArray = new char[]{'-'};
        String digits = StringsKt.trimStart((String)string, (char[])cArray);
        if (groupSize > 0) {
            String string2 = digits;
            Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.CharSequence");
            digits = CollectionsKt.joinToString$default((Iterable)CollectionsKt.asReversed((List)StringsKt.chunked((CharSequence)StringsKt.reversed((CharSequence)string2), (int)groupSize, (Function1)emitValue.1.INSTANCE)), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        }
        return this.emit(representation.getPrefix()).emit(digits);
    }

    public static /* synthetic */ TomlEmitter emitValue$default(TomlEmitter tomlEmitter, long l, IntegerRepresentation integerRepresentation, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: emitValue");
        }
        if ((n2 & 2) != 0) {
            integerRepresentation = IntegerRepresentation.DECIMAL;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return tomlEmitter.emitValue(l, integerRepresentation, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TomlEmitter emitValue(double d) {
        String string;
        TomlEmitter tomlEmitter = this;
        if (Double.isNaN(d)) {
            string = "nan";
        } else if (Double.isInfinite(d)) {
            string = d > 0.0 ? "inf" : "-inf";
        } else {
            void it;
            String string2 = String.valueOf(d);
            TomlEmitter tomlEmitter2 = tomlEmitter;
            boolean bl = false;
            string = StringsKt.contains$default((CharSequence)((CharSequence)it), (char)'.', (boolean)false, (int)2, null) ? it : (String)it + ".0";
            tomlEmitter = tomlEmitter2;
        }
        return tomlEmitter.emit(string);
    }

    @NotNull
    public final TomlEmitter emitValue(boolean bl) {
        return this.emit(String.valueOf(bl));
    }

    @NotNull
    public final TomlEmitter emitValue(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return this.emit(instant.toString());
    }

    @NotNull
    public final TomlEmitter emitValue(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        return this.emit(dateTime.toString());
    }

    @NotNull
    public final TomlEmitter emitValue(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.emit(date.toString());
    }

    @NotNull
    public final TomlEmitter emitValue(@NotNull LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return this.emit(time.toString());
    }

    @NotNull
    public final TomlEmitter emitNullValue() {
        return this.emit("null");
    }

    @NotNull
    public final TomlEmitter startArray() {
        return this.emit('[');
    }

    @NotNull
    public final TomlEmitter endArray() {
        return this.emit(']');
    }

    @NotNull
    public final TomlEmitter startInlineTable() {
        return this.emit('{');
    }

    @NotNull
    public final TomlEmitter endInlineTable() {
        return this.emit('}');
    }

    @NotNull
    public final TomlEmitter emitElementDelimiter() {
        return this.emit(",");
    }

    @NotNull
    public final TomlEmitter emitPairDelimiter() {
        return this.emit(" = ");
    }
}

