/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.Tooltip;
import dev.lambdaurora.spruceui.Tooltipable;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.wrapper.VanillaButtonWrapper;
import java.util.Optional;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpruceButtonWidget
extends AbstractSpruceWidget
implements Tooltipable {
    private class_2561 message;
    private class_2561 tooltip;
    private int tooltipTicks;
    private long lastTick;
    protected float alpha = 1.0f;
    protected static final class_8666 BUTTON_TEXTURES = new class_8666(class_2960.method_60656((String)"widget/button"), class_2960.method_60656((String)"widget/button_disabled"), class_2960.method_60656((String)"widget/button_highlighted"));

    public AbstractSpruceButtonWidget(Position position, int width, int height, class_2561 message) {
        super(position);
        this.width = width;
        this.height = height;
        this.message = message;
    }

    public class_2561 getMessage() {
        return this.message;
    }

    public void setMessage(class_2561 message) {
        this.message = message;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float value) {
        this.alpha = value;
    }

    @Override
    public Optional<class_2561> getTooltip() {
        return Optional.ofNullable(this.tooltip);
    }

    @Override
    public void setTooltip(@Nullable class_2561 tooltip) {
        this.tooltip = tooltip;
    }

    public VanillaButtonWrapper asVanilla() {
        return new VanillaButtonWrapper(this);
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isValidClickButton(button)) {
            this.onDrag(mouseX, mouseY, deltaX, deltaY);
            return true;
        }
        return false;
    }

    protected void onClick(double mouseX, double mouseY) {
    }

    protected void onRelease(double mouseX, double mouseY) {
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
    }

    protected class_2960 getTexture() {
        return BUTTON_TEXTURES.method_52729(this.method_37303(), this.isFocusedOrHovered());
    }

    @Override
    protected void renderWidget(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.renderButton(graphics, mouseX, mouseY, delta);
        if (!this.dragging) {
            Tooltip.queueFor(this, mouseX, mouseY, this.tooltipTicks, i -> {
                this.tooltipTicks = i;
            }, this.lastTick, i -> {
                this.lastTick = i;
            });
        }
    }

    protected void renderButton(class_332 graphics, int mouseX, int mouseY, float delta) {
        int color = this.active ? 0xFFFFFF : 0xA0A0A0;
        this.renderText(graphics, color | class_3532.method_15386((float)(this.alpha * 255.0f)) << 24);
    }

    protected void renderText(class_332 graphics, int color) {
        int margin = 2;
        int startX = this.getX() + margin;
        int endX = this.getX() + this.getWidth() - margin;
        class_339.method_52718((class_332)graphics, (class_327)this.client.field_1772, (class_2561)this.getMessage(), (int)startX, (int)this.getY(), (int)endX, (int)(this.getY() + this.getHeight()), (int)color);
    }

    @Override
    protected void renderBackground(class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_52706(class_1921::method_62277, this.getTexture(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    @Nullable
    protected class_2561 getNarrationMessage() {
        return class_2561.method_43469((String)"gui.narrate.button", (Object[])new Object[]{this.getMessage()});
    }

    protected class_2561 getNarrationFocusedUsageMessage() {
        return class_2561.method_43471((String)"narration.button.usage.focused");
    }

    protected class_2561 getNarrationHoveredUsageMessage() {
        return class_2561.method_43471((String)"narration.button.usage.hovered");
    }

    @Override
    public void method_37020(class_6382 builder) {
        super.method_37020(builder);
        if (this.method_37303()) {
            if (this.method_25370()) {
                builder.method_37034(class_6381.field_33791, this.getNarrationFocusedUsageMessage());
            } else {
                builder.method_37034(class_6381.field_33791, this.getNarrationHoveredUsageMessage());
            }
        }
        this.getTooltip().ifPresent(text -> builder.method_37034(class_6381.field_33790, text));
    }
}

