/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.client.fluid;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiProviderMap;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class FluidVariantRendering {
    private static final ApiProviderMap<class_3611, FluidVariantRenderHandler> HANDLERS = ApiProviderMap.create();
    private static final FluidVariantRenderHandler DEFAULT_HANDLER = new FluidVariantRenderHandler(){};

    private FluidVariantRendering() {
    }

    public static void register(class_3611 fluid, FluidVariantRenderHandler handler) {
        if (HANDLERS.putIfAbsent((Object)fluid, (Object)handler) != null) {
            throw new IllegalArgumentException("Duplicate handler registration for fluid " + String.valueOf(fluid));
        }
    }

    @Nullable
    public static FluidVariantRenderHandler getHandler(class_3611 fluid) {
        return (FluidVariantRenderHandler)HANDLERS.get((Object)fluid);
    }

    public static FluidVariantRenderHandler getHandlerOrDefault(class_3611 fluid) {
        FluidVariantRenderHandler handler = (FluidVariantRenderHandler)HANDLERS.get((Object)fluid);
        return handler == null ? DEFAULT_HANDLER : handler;
    }

    public static List<class_2561> getTooltip(FluidVariant fluidVariant) {
        return FluidVariantRendering.getTooltip(fluidVariant, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
    }

    public static List<class_2561> getTooltip(FluidVariant fluidVariant, class_1836 type) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add(FluidVariantAttributes.getName(fluidVariant));
        FluidVariantRendering.getHandlerOrDefault(fluidVariant.getFluid()).appendTooltip(fluidVariant, tooltip, type);
        if (type.method_8035()) {
            tooltip.add((class_2561)class_2561.method_43470((String)class_7923.field_41173.method_10221((Object)fluidVariant.getFluid()).toString()).method_27692(class_124.field_1063));
        }
        return tooltip;
    }

    @Nullable
    public static class_1058[] getSprites(FluidVariant fluidVariant) {
        return FluidVariantRendering.getHandlerOrDefault(fluidVariant.getFluid()).getSprites(fluidVariant);
    }

    @Nullable
    public static class_1058 getSprite(FluidVariant fluidVariant) {
        class_1058[] sprites = FluidVariantRendering.getSprites(fluidVariant);
        return sprites != null ? Objects.requireNonNull(sprites[0]) : null;
    }

    public static int getColor(FluidVariant fluidVariant) {
        return FluidVariantRendering.getColor(fluidVariant, null, null);
    }

    public static int getColor(FluidVariant fluidVariant, @Nullable class_1920 view, @Nullable class_2338 pos) {
        return FluidVariantRendering.getHandlerOrDefault(fluidVariant.getFluid()).getColor(fluidVariant, view, pos);
    }
}

