/*
 * Decompiled with CFR 0.152.
 */
package me.splitque.log;

import me.splitque.log.LogFile;
import me.splitque.log.variables.File;
import me.splitque.log.variables.Prefix;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class Logger {
    String name;
    String color;
    Boolean saveLogsToFile;
    Boolean useLog4j;
    org.apache.logging.log4j.Logger log4f;

    public Logger(String name, String color, Boolean saveLogsToFile, Boolean useLog4j) {
        this.name = name;
        this.color = color;
        this.saveLogsToFile = saveLogsToFile;
        this.useLog4j = useLog4j;
        if (this.useLog4j.booleanValue()) {
            this.log4f = LogManager.getLogger((String)this.name);
        }
    }

    public void message(String logConsole, String logFile) {
        if (this.useLog4j.booleanValue()) {
            this.log4f.log(Level.INFO, logConsole);
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + logFile);
            }
        } else {
            System.out.println(Prefix.NAME(this.name, this.color) + "\u001b[97m" + logConsole + "\u001b[39m");
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + logFile);
            }
        }
    }

    public void info(String logConsole, String logFile) {
        if (this.useLog4j.booleanValue()) {
            this.log4f.log(Level.INFO, logConsole);
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + "[INFO] " + logFile);
            }
        } else {
            System.out.println(Prefix.NAME(this.name, this.color) + "\u001b[39m[INFO] " + logConsole + "\u001b[39m");
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + "[INFO] " + logFile);
            }
        }
    }

    public void info(String logConsole, String logFile, Boolean showMessage) {
        if (showMessage.booleanValue()) {
            if (this.useLog4j.booleanValue()) {
                this.log4f.log(Level.INFO, logConsole);
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + "[INFO] " + logFile);
                }
            } else {
                System.out.println(Prefix.NAME(this.name, this.color) + "\u001b[39m[INFO] " + logConsole + "\u001b[39m");
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + "[INFO] " + logFile);
                }
            }
        }
    }

    public void custom(String logConsole, String logFile, String title, String color) {
        if (this.useLog4j.booleanValue()) {
            this.log4f.log(Level.INFO, Prefix.LOG4J_CUSTOM(title) + logConsole);
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + File.CUSTOM(title) + logFile);
            }
        } else {
            System.out.println(Prefix.NAME(this.name, this.color) + Prefix.CUSTOM(title, color) + logConsole + "\u001b[39m");
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + File.CUSTOM(title) + logFile);
            }
        }
    }

    public void custom(String logConsole, String logFile, String title, String color, boolean showMessage) {
        if (showMessage) {
            if (this.useLog4j.booleanValue()) {
                this.log4f.log(Level.INFO, Prefix.LOG4J_CUSTOM(title) + logConsole);
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + File.CUSTOM(title) + logFile);
                }
            } else {
                System.out.println(Prefix.NAME(this.name, this.color) + Prefix.CUSTOM(title, color) + logConsole + "\u001b[39m");
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + File.CUSTOM(title) + logFile);
                }
            }
        }
    }

    public void custom(String logConsole, String logFile, int code, String title, String color) {
        if (this.useLog4j.booleanValue()) {
            this.log4f.log(Level.INFO, Prefix.LOG4J_CUSTOM_CODE(title, code) + logConsole);
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + File.CUSTOM(title) + logFile);
            }
        } else {
            System.out.println(Prefix.NAME(this.name, this.color) + Prefix.CUSTOM_CODE(title, color, code) + logConsole + "\u001b[39m");
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + File.CUSTOM(title) + logFile);
            }
        }
    }

    public void custom(String logConsole, String logFile, int code, String title, String color, boolean showMessage) {
        if (showMessage) {
            if (this.useLog4j.booleanValue()) {
                this.log4f.log(Level.INFO, Prefix.LOG4J_CUSTOM_CODE(title, code) + logConsole);
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + File.CUSTOM(title) + logFile);
                }
            } else {
                System.out.println(Prefix.NAME(this.name, this.color) + Prefix.CUSTOM_CODE(title, color, code) + logConsole + "\u001b[39m");
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + File.CUSTOM(title) + logFile);
                }
            }
        }
    }

    public void warn(String logConsole, String logFile) {
        if (this.useLog4j.booleanValue()) {
            this.log4f.log(Level.WARN, logConsole);
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + "[WARN] " + logFile);
            }
        } else {
            System.out.println(Prefix.NAME(this.name, this.color) + "\u001b[93m[WARN] " + logConsole + "\u001b[39m");
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + "[WARN] " + logFile);
            }
        }
    }

    public void warn(String logConsole, String logFile, Boolean showMessage) {
        if (showMessage.booleanValue()) {
            if (this.useLog4j.booleanValue()) {
                this.log4f.log(Level.WARN, logConsole);
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + "[WARN] " + logFile);
                }
            } else {
                System.out.println(Prefix.NAME(this.name, this.color) + "\u001b[93m[WARN] " + logConsole + "\u001b[39m");
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + "[WARN] " + logFile);
                }
            }
        }
    }

    public void error(String logConsole, String logFile) {
        if (this.useLog4j.booleanValue()) {
            this.log4f.log(Level.ERROR, logConsole);
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + "[ERROR] " + logFile);
            }
        } else {
            System.out.println(Prefix.NAME(this.name, this.color) + "\u001b[31m[ERROR] " + logConsole + "\u001b[39m");
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + "[ERROR] " + logFile);
            }
        }
    }

    public void error(String logConsole, String logFile, boolean showMessage) {
        if (showMessage) {
            if (this.useLog4j.booleanValue()) {
                this.log4f.log(Level.ERROR, logConsole);
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + "[ERROR] " + logFile);
                }
            } else {
                System.out.println(Prefix.NAME(this.name, this.color) + "\u001b[31m[ERROR] " + logConsole + "\u001b[39m");
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + "[ERROR] " + logFile);
                }
            }
        }
    }

    public void error(String logConsole, String logFile, int errorCode) {
        if (this.useLog4j.booleanValue()) {
            this.log4f.log(Level.ERROR, Prefix.LOG4J_CODE(errorCode) + logConsole);
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + File.ERROR_CODE(errorCode) + logFile);
            }
        } else {
            System.out.println(Prefix.NAME(this.name, this.color) + Prefix.ERROR_CODE(errorCode) + logConsole + "\u001b[39m");
            if (this.saveLogsToFile.booleanValue()) {
                LogFile.saveLog(File.NAME(this.name) + File.ERROR_CODE(errorCode) + logFile);
            }
        }
    }

    public void error(String logConsole, String logFile, boolean showMessage, int errorCode) {
        if (showMessage) {
            if (this.useLog4j.booleanValue()) {
                this.log4f.log(Level.ERROR, Prefix.LOG4J_CODE(errorCode) + logConsole);
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + File.ERROR_CODE(errorCode) + logFile);
                }
            } else {
                System.out.println(Prefix.NAME(this.name, this.color) + Prefix.ERROR_CODE(errorCode) + logConsole + "\u001b[39m");
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + File.ERROR_CODE(errorCode) + logFile);
                }
            }
        }
    }

    public void debug(String logConsole, String logFile, boolean showMessage) {
        if (showMessage) {
            if (this.useLog4j.booleanValue()) {
                this.log4f.log(Level.DEBUG, logConsole);
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + "[DEBUG] " + logFile);
                }
            } else {
                System.out.println(Prefix.NAME(this.name, this.color) + "\u001b[90m[DEBUG] " + logConsole + "\u001b[39m");
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + "[DEBUG] " + logFile);
                }
            }
        }
    }

    public void debug(String logConsole, String logFile, boolean showMessage, int debugCode) {
        if (showMessage) {
            if (this.useLog4j.booleanValue()) {
                this.log4f.log(Level.DEBUG, Prefix.LOG4J_CODE(debugCode) + logConsole);
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + "[DEBUG] " + logFile);
                }
            } else {
                System.out.println(Prefix.NAME(this.name, this.color) + Prefix.DEBUG_CODE(debugCode) + logConsole + "\u001b[39m");
                if (this.saveLogsToFile.booleanValue()) {
                    LogFile.saveLog(File.NAME(this.name) + File.DEBUG_CODE(debugCode) + logFile);
                }
            }
        }
    }
}

