/*
 * Decompiled with CFR 0.152.
 */
package me.splitque.configuration;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import me.splitque.configuration.ConfigAPI;
import me.splitque.configuration.filetypes.ConfigurationType;
import me.splitque.configuration.filetypes.JSON;
import me.splitque.configuration.filetypes.PROPERTIES;

public class ConfigHandler
extends ConfigAPI {
    private ConfigurationType config;
    private Path configPath;

    public ConfigHandler(Boolean useJarDir, String path, String name, String type) {
        this.configPath = path == null ? (useJarDir.booleanValue() ? Path.of(this.getJarDir() + "/" + name + "." + type.toLowerCase(), new String[0]) : Path.of(name + "." + type.toLowerCase(), new String[0])) : (useJarDir != false ? Path.of(this.getJarDir() + "/" + path + "/" + name + "." + type.toLowerCase(), new String[0]) : Path.of(path + "/" + name + "." + type.toLowerCase(), new String[0]));
        switch (type) {
            case "PROPERTIES": {
                this.config = new PROPERTIES();
                if (!Files.exists(this.configPath, new LinkOption[0])) {
                    this.config.create(this.configPath);
                    break;
                }
                try (BufferedReader reader = this.getReader(this.configPath);){
                    this.config.load(null, reader);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "JSON": {
                this.config = new JSON();
                if (!Files.exists(this.configPath, new LinkOption[0])) {
                    this.config.create(this.configPath);
                    break;
                }
                this.config.load(this.configPath, null);
            }
        }
    }

    public void putOption(String key, String value) {
        this.config.putOption(key, value);
        try (BufferedWriter writer = this.getWriter(this.configPath);){
            this.config.save(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setOption(String key, String value) {
        this.config.setOption(key, value);
        try (BufferedWriter writer = this.getWriter(this.configPath);){
            this.config.save(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getString(String key) {
        return this.config.getString(key);
    }

    public Boolean getBoolean(String key) {
        return this.config.getBoolean(key);
    }

    public int getInt(String key) {
        return this.config.getInt(key);
    }

    public Double getDouble(String key) {
        return this.config.getDouble(key);
    }
}

