/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.api;

import dev.schmarrn.lighty.config.Config;

public class LightyColors {
    private static int getSafeARGB() {
        return (Integer)Config.OVERLAY_GREEN.getValue() | 0xFF000000;
    }

    private static int getWarningARGB() {
        return (Integer)Config.OVERLAY_ORANGE.getValue() | 0xFF000000;
    }

    private static int getDangerARGB() {
        return (Integer)Config.OVERLAY_RED.getValue() | 0xFF000000;
    }

    public static int getARGB(int blockLightLevel, int skyLightLevel) {
        if (blockLightLevel > (Integer)Config.BLOCK_THRESHOLD.getValue()) {
            return LightyColors.getSafeARGB();
        }
        if (skyLightLevel > (Integer)Config.SKY_THRESHOLD.getValue()) {
            return LightyColors.getWarningARGB();
        }
        return LightyColors.getDangerARGB();
    }

    public static int getGrowthARGB(int blockLightLevel, int skyLightLevel) {
        int internalLightLevel = Integer.max(blockLightLevel, skyLightLevel);
        if (internalLightLevel > (Integer)Config.FARM_GROWTH_THRESHOLD.getValue()) {
            return (Integer)Config.ADDITIONAL_OVERLAY_GOOD.getValue() | 0xFF000000;
        }
        if (internalLightLevel < (Integer)Config.FARM_UPROOT_THRESHOLD.getValue()) {
            return (Integer)Config.ADDITIONAL_OVERLAY_BAD.getValue() | 0xFF000000;
        }
        return (Integer)Config.ADDITIONAL_OVERLAY_WARN.getValue() | 0xFF000000;
    }

    private LightyColors() {
    }
}

