/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.conditionalmixin.impl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.fallenbreath.conditionalmixin.ConditionalMixinMod;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.fallenbreath.conditionalmixin.api.checker.RestrictionChecker;
import me.fallenbreath.conditionalmixin.api.mixin.ConditionTester;
import me.fallenbreath.conditionalmixin.api.mixin.RestrictionCheckFailureCallback;
import me.fallenbreath.conditionalmixin.api.util.VersionChecker;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class SimpleRestrictionChecker
implements RestrictionChecker {
    private RestrictionCheckFailureCallback failureCallback = null;

    @Override
    public boolean checkRestriction(String mixinClassName) {
        AnnotationNode restriction;
        try {
            restriction = this.getRestrictionAnnotation(mixinClassName);
        }
        catch (ClassNotFoundException e) {
            this.onRestrictionCheckFailure(mixinClassName, String.format("class '%s' not found", mixinClassName));
            return false;
        }
        if (restriction == null) {
            return true;
        }
        List enableConditions = Annotations.getValue((AnnotationNode)restriction, (String)"require", (boolean)true);
        for (Result result : this.checkConditions(mixinClassName, enableConditions)) {
            if (result.success) continue;
            this.onRestrictionCheckFailure(mixinClassName, result.reason);
            return false;
        }
        List disableConditions = Annotations.getValue((AnnotationNode)restriction, (String)"conflict", (boolean)true);
        for (Result result : this.checkConditions(mixinClassName, disableConditions)) {
            if (!result.success) continue;
            this.onRestrictionCheckFailure(mixinClassName, result.reason);
            return false;
        }
        return true;
    }

    @Override
    public void setFailureCallback(RestrictionCheckFailureCallback failureCallback) {
        this.failureCallback = failureCallback;
    }

    @Nullable
    private AnnotationNode getRestrictionAnnotation(String className) throws ClassNotFoundException {
        ClassNode classNode;
        try {
            classNode = MixinService.getService().getBytecodeProvider().getClassNode(className);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ClassNotFoundException();
        }
        return Annotations.getVisible((ClassNode)classNode, Restriction.class);
    }

    private List<Result> checkConditions(String mixinClassName, List<AnnotationNode> conditions) {
        ArrayList results = Lists.newArrayList();
        for (AnnotationNode condition : conditions) {
            Condition.Type type = (Condition.Type)Annotations.getValue((AnnotationNode)condition, (String)"type", Condition.Type.class, (Enum)Condition.Type.MOD);
            switch (type) {
                case MOD: {
                    String modId = (String)Annotations.getValue((AnnotationNode)condition, (String)"value");
                    Objects.requireNonNull(modId, "field value is required for condition type MOD, as the mod ID");
                    if (!VersionChecker.isModPresent(modId)) {
                        results.add(new Result(false, String.format("required mod %s not found", modId)));
                        break;
                    }
                    ArrayList versionPredicates = Lists.newArrayList((Iterable)((Iterable)Annotations.getValue((AnnotationNode)condition, (String)"versionPredicates", (Object)Lists.newArrayList())));
                    String versionString = VersionChecker.getModVersionString(modId).orElseThrow(IllegalStateException::new);
                    if (!VersionChecker.doesModVersionSatisfyPredicate(modId, versionPredicates)) {
                        results.add(new Result(false, String.format("mod %s@%s does not matches version predicates %s", modId, versionString, versionPredicates)));
                        break;
                    }
                    results.add(new Result(true, String.format("conflicted/unsupported mod %s@%s found", modId, versionString)));
                    break;
                }
                case MIXIN: {
                    String requiredMixinClassName = (String)Annotations.getValue((AnnotationNode)condition, (String)"value");
                    Objects.requireNonNull(requiredMixinClassName, "field tester is required for condition type MIXIN, as the required mixin class name");
                    if (!this.checkRestriction(requiredMixinClassName)) {
                        results.add(new Result(false, String.format("required mixin class %s disabled", requiredMixinClassName)));
                        break;
                    }
                    results.add(new Result(true, String.format("conflicted mixin class %s found", requiredMixinClassName)));
                    break;
                }
                case TESTER: {
                    ConditionTester tester;
                    Type clazzType = (Type)Annotations.getValue((AnnotationNode)condition, (String)"tester");
                    Objects.requireNonNull(clazzType, "field tester is required for condition type TESTER");
                    try {
                        Class<?> clazz = Class.forName(clazzType.getClassName());
                        if (clazz.isInterface()) {
                            ConditionalMixinMod.LOGGER.error("Tester class {} is a interface, but it should be a class", (Object)clazz.getName());
                            break;
                        }
                        tester = (ConditionTester)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        ConditionalMixinMod.LOGGER.error("Failed to instantiate a ConditionTester from class {}: {}", (Object)clazzType.getClassName(), (Object)e);
                        break;
                    }
                    boolean testingResult = tester.isSatisfied(mixinClassName);
                    results.add(new Result(testingResult, String.format("tester result = %s", testingResult)));
                }
            }
        }
        return results;
    }

    private void onRestrictionCheckFailure(String mixinClassName, String reason) {
        if (this.failureCallback != null) {
            this.failureCallback.callback(mixinClassName, reason);
        }
    }

    private static class Result {
        public final boolean success;
        public final String reason;

        private Result(boolean success, String reason) {
            this.success = success;
            this.reason = reason;
        }
    }
}

