/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.utils;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1440;
import net.minecraft.class_1451;
import net.minecraft.class_1452;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1498;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3701;
import net.minecraft.class_4019;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4760;
import net.minecraft.class_5762;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7102;
import net.minecraft.class_7833;
import net.minecraft.class_8153;
import net.minecraft.class_898;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class Utils {
    public static List<class_1856> createCombinedResultIngredients(String mobIngredients, int minCount, int maxCount) {
        String[] ingredientIds = mobIngredients.split(",");
        ArrayList<class_1856> resultIngredients = new ArrayList<class_1856>();
        ArrayList<class_6880> combinedItemStacks = new ArrayList<class_6880>();
        for (int count = minCount; count <= maxCount; ++count) {
            for (String ingredientId : ingredientIds) {
                class_2960 resourceLocation = class_2960.method_12829((String)ingredientId.trim());
                class_1792 ingredientItem = JustEnoughBreeding.getItemFromLoaderRegistries(resourceLocation);
                if (resourceLocation == null || ingredientItem == class_1802.field_8162) continue;
                combinedItemStacks.add(new class_1799((class_1935)ingredientItem, count).method_41409());
            }
        }
        if (!combinedItemStacks.isEmpty()) {
            resultIngredients.add(class_1856.method_8106((class_6885)class_6885.method_40242(combinedItemStacks)));
        }
        return resultIngredients;
    }

    public static BreedingRecipe createBreedingRecipe(class_1299<?> entityType, class_1856 combinedIngredient, class_1792 spawnEggItem, Boolean needsToBeTamed, @Nullable List<class_1856> resultItemStacks, Boolean animalTrusting, @Nullable class_1856 combinedExtraIngredient) {
        if (resultItemStacks == null || resultItemStacks.isEmpty()) {
            return new BreedingRecipe(entityType, combinedIngredient, new class_1799((class_1935)spawnEggItem), needsToBeTamed, null, combinedExtraIngredient, animalTrusting);
        }
        ArrayList list = new ArrayList();
        for (class_1856 resultItemStack : resultItemStacks) {
            if (resultItemStack == null || resultItemStack.method_8105().toList().isEmpty()) continue;
            list.addAll(resultItemStack.method_8105().toList());
        }
        class_1856 mergedResultItemStacks = class_1856.method_8106((class_6885)class_6885.method_40242(list));
        return new BreedingRecipe(entityType, combinedIngredient, new class_1799((class_1935)spawnEggItem), needsToBeTamed, mergedResultItemStacks, combinedExtraIngredient, animalTrusting);
    }

    public static class_1856 createCombinedIngredient(String mobIngredients) {
        String[] ingredientIds = mobIngredients.split(",");
        ArrayList<class_1856> combinedIngredients = new ArrayList<class_1856>();
        for (String ingredientId : ingredientIds) {
            if (ingredientId.trim().startsWith("#")) {
                combinedIngredients.add(CommonUtils.createTagIngredient(ingredientId));
                continue;
            }
            class_1792 ingredientItem = JustEnoughBreeding.getItemFromLoaderRegistries(class_2960.method_60654((String)ingredientId.trim()));
            combinedIngredients.add(class_1856.method_8101((class_1935)new class_1799((class_1935)ingredientItem).method_7909()));
        }
        ArrayList list = new ArrayList();
        for (class_1856 resultItemStack : combinedIngredients) {
            list.addAll(resultItemStack.method_8105().toList());
        }
        return class_1856.method_8106((class_6885)class_6885.method_40242(list));
    }

    public static void renderEntity(@NotNull class_4587 stack, double mouseX, class_1309 currentLivingEntity) {
        float yawRadians;
        int entityPosX = 31;
        int entityPosY = 89;
        int ENTITY_RENDER_DISTANCE = 0xF000F0;
        float yaw = (float)(60.0 - mouseX);
        stack.method_22903();
        stack.method_46416((float)entityPosX, (float)entityPosY, 50.0f);
        class_238 boundingBox = currentLivingEntity.method_5829();
        double largestDimension = Math.max(boundingBox.method_17939(), Math.max(boundingBox.method_17940(), boundingBox.method_17941()));
        float desiredWidth = 30.0f;
        float desiredHeight = 40.0f;
        float scaleX = desiredWidth / (float)largestDimension;
        float scaleY = desiredHeight / (float)largestDimension;
        float scalingFactor = Math.min(scaleX, scaleY);
        if (currentLivingEntity instanceof class_7102) {
            scalingFactor = 50.0f;
        }
        if (currentLivingEntity instanceof class_5762 || currentLivingEntity instanceof class_1451 || currentLivingEntity instanceof class_1452 || currentLivingEntity instanceof class_1493) {
            scalingFactor = 25.0f;
        }
        if (currentLivingEntity instanceof class_3701 || currentLivingEntity instanceof class_4019 || currentLivingEntity instanceof class_1481) {
            scalingFactor = 20.0f;
        }
        if (currentLivingEntity instanceof class_4760 || currentLivingEntity instanceof class_1498 || currentLivingEntity instanceof class_1440) {
            scalingFactor = 15.0f;
        }
        if (currentLivingEntity instanceof class_8153) {
            scalingFactor = 10.0f;
        }
        stack.method_22905(scalingFactor, scalingFactor, scalingFactor);
        stack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        currentLivingEntity.field_6283 = yawRadians = -(yaw / 40.0f) * 20.0f;
        currentLivingEntity.method_36456(yawRadians);
        currentLivingEntity.field_6241 = yawRadians;
        currentLivingEntity.field_6259 = yawRadians;
        class_310 instance = class_310.method_1551();
        class_898 entityRenderDispatcher = instance.method_1561();
        entityRenderDispatcher.method_24196(new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f));
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 bufferSource = instance.method_22940().method_23000();
        entityRenderDispatcher.method_62424((class_1297)currentLivingEntity, 0.0, 0.0, 0.0, 1.0f, stack, (class_4597)bufferSource, ENTITY_RENDER_DISTANCE);
        bufferSource.method_22993();
        entityRenderDispatcher.method_3948(true);
        stack.method_22909();
    }
}

