/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.platform.network.SidedNetworkApi;
import dev.isxander.controlify.server.ControlifyHandshake;
import dev.isxander.controlify.server.ControlifyServerConfig;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.server.VibrateCommand;
import dev.isxander.controlify.server.packets.EntityVibrationPacket;
import dev.isxander.controlify.server.packets.OriginVibrationPacket;
import dev.isxander.controlify.server.packets.ServerPolicyPacket;
import dev.isxander.controlify.server.packets.VibrationPacket;
import dev.isxander.controlify.utils.CUtil;
import net.minecraft.class_2168;

public class ControlifyServer {
    private static ControlifyServer INSTANCE;

    public static ControlifyServer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ControlifyServer();
        }
        return INSTANCE;
    }

    public void onInitialize() {
        ControlifyHandshake.setupOnServer();
        SidedNetworkApi.S2C().registerPacket(VibrationPacket.CHANNEL, VibrationPacket.CODEC);
        SidedNetworkApi.S2C().registerPacket(OriginVibrationPacket.CHANNEL, OriginVibrationPacket.CODEC);
        SidedNetworkApi.S2C().registerPacket(EntityVibrationPacket.CHANNEL, EntityVibrationPacket.CODEC);
        SidedNetworkApi.S2C().registerPacket(ServerPolicyPacket.CHANNEL, ServerPolicyPacket.CODEC);
        PlatformMainUtil.registerCommandRegistrationCallback((dispatcher, registry, env) -> VibrateCommand.register((CommandDispatcher<class_2168>)dispatcher));
    }

    public void onInitializeServer() {
        ControlifyServerConfig.HANDLER.load();
        ControlifyServerConfig.HANDLER.save();
        CUtil.LOGGER.info("Reach-around policy: {}", (Object)((ControlifyServerConfig)ControlifyServerConfig.HANDLER.instance()).reachAroundPolicy);
        CUtil.LOGGER.info("No-fly drift policy: {}", (Object)((ControlifyServerConfig)ControlifyServerConfig.HANDLER.instance()).noFlyDriftPolicy);
        PlatformMainUtil.registerPlayerJoinedEvent(player -> {
            SidedNetworkApi.S2C().sendPacket(player, ServerPolicyPacket.CHANNEL, new ServerPolicyPacket(ServerPolicies.REACH_AROUND.getId(), ((ControlifyServerConfig)ControlifyServerConfig.HANDLER.instance()).reachAroundPolicy));
            SidedNetworkApi.S2C().sendPacket(player, ServerPolicyPacket.CHANNEL, new ServerPolicyPacket(ServerPolicies.DISABLE_FLY_DRIFTING.getId(), ((ControlifyServerConfig)ControlifyServerConfig.HANDLER.instance()).noFlyDriftPolicy));
        });
    }
}

