/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.GamepadInputs;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.input.mapping.ControllerMapping;
import dev.isxander.controlify.controller.input.mapping.MapType;
import dev.isxander.controlify.controller.input.mapping.MappingEntry;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ClientUtils;
import dev.isxander.controlify.utils.ColorUtils;
import dev.isxander.controlify.utils.render.Blit;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class ControllerMappingMakerScreen
extends class_437
implements ScreenControllerEventListener,
ScreenProcessorProvider,
DontInteruptScreen {
    private final InputComponent inputComponent;
    private final ControllerMapping.Builder mappingBuilder = new ControllerMapping.Builder();
    private final ScreenProcessor<ControllerMappingMakerScreen> screenProcessor = new ScreenProcessorImpl(this);
    private int delayTillNextStage = 20;
    public static final List<MappingStage> GAMEPAD_STAGES = List.of(new MappingStage(GamepadInputs.SOUTH_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("face_down"), "face_down", "faceview"), new MappingStage(GamepadInputs.WEST_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("face_left"), "face_left", "faceview"), new MappingStage(GamepadInputs.EAST_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("face_right"), "face_right", "faceview"), new MappingStage(GamepadInputs.NORTH_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("face_up"), "face_up", "faceview"), new MappingStage(GamepadInputs.LEFT_SHOULDER_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("left_bumper"), "left_bumper", "triggerview"), new MappingStage(GamepadInputs.RIGHT_SHOULDER_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("right_bumper"), "right_bumper", "triggerview"), new MappingStage(GamepadInputs.START_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("left_special"), "left_special", "faceview"), new MappingStage(GamepadInputs.GUIDE_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("right_special"), "right_special", "faceview"), new MappingStage(GamepadInputs.LEFT_STICK_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("left_stick_down"), "left_stick_press", "faceview"), new MappingStage(GamepadInputs.RIGHT_STICK_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("right_stick_down"), "right_stick_press", "faceview"), new MappingStage(GamepadInputs.DPAD_UP_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("dpad_up"), "dpad_up", "faceview"), new MappingStage(GamepadInputs.DPAD_LEFT_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("dpad_left"), "dpad_left", "faceview"), new MappingStage(GamepadInputs.DPAD_DOWN_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("dpad_down"), "dpad_down", "faceview"), new MappingStage(GamepadInputs.DPAD_RIGHT_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("dpad_right"), "dpad_right", "faceview"), new MappingStage(GamepadInputs.LEFT_STICK_AXIS_LEFT, MapType.AXIS, ControllerMappingMakerScreen.axis("left_stick", true), "left_stick_left", "faceview"), new MappingStage(GamepadInputs.LEFT_STICK_AXIS_DOWN, MapType.AXIS, ControllerMappingMakerScreen.axis("left_stick", false), "left_stick_down", "faceview"), new MappingStage(GamepadInputs.LEFT_STICK_AXIS_RIGHT, MapType.AXIS, ControllerMappingMakerScreen.axis("left_stick", true), "left_stick_right", "faceview"), new MappingStage(GamepadInputs.LEFT_STICK_AXIS_UP, MapType.AXIS, ControllerMappingMakerScreen.axis("left_stick", false), "left_stick_up", "faceview"), new MappingStage(GamepadInputs.RIGHT_STICK_AXIS_LEFT, MapType.AXIS, ControllerMappingMakerScreen.axis("right_stick", true), "right_stick_left", "faceview"), new MappingStage(GamepadInputs.RIGHT_STICK_AXIS_DOWN, MapType.AXIS, ControllerMappingMakerScreen.axis("right_stick", false), "right_stick_down", "faceview"), new MappingStage(GamepadInputs.RIGHT_STICK_AXIS_RIGHT, MapType.AXIS, ControllerMappingMakerScreen.axis("right_stick", true), "right_stick_right", "faceview"), new MappingStage(GamepadInputs.RIGHT_STICK_AXIS_UP, MapType.AXIS, ControllerMappingMakerScreen.axis("right_stick", false), "right_stick_up", "faceview"), new MappingStage(GamepadInputs.LEFT_TRIGGER_AXIS, MapType.AXIS, (class_2561)class_2561.method_43471((String)"controlify.gui.mapping_maker.instruction.left_trigger"), "left_trigger", "triggerview"), new MappingStage(GamepadInputs.RIGHT_TRIGGER_AXIS, MapType.AXIS, (class_2561)class_2561.method_43471((String)"controlify.gui.mapping_maker.instruction.right_trigger"), "right_trigger", "triggerview"));
    private MappingStage currentStage = null;
    private final List<MappingStage> stages;
    private class_4185 goBackButton;
    private final class_437 lastScreen;

    public ControllerMappingMakerScreen(InputComponent inputComponent, class_437 lastScreen, List<MappingStage> stages, Iterable<DeadzoneGroup> deadzoneGroups) {
        super((class_2561)class_2561.method_43470((String)"Gamepad Emulation Mapping Creator"));
        this.inputComponent = inputComponent;
        this.lastScreen = lastScreen;
        this.stages = stages;
        this.mappingBuilder.putDeadzoneGroups(deadzoneGroups);
        ((InputComponent.Config)inputComponent.confObj()).mapping = null;
    }

    public static ControllerMappingMakerScreen createGamepadMapping(InputComponent inputComponent, class_437 lastScreen) {
        return new ControllerMappingMakerScreen(inputComponent, lastScreen, GAMEPAD_STAGES, GamepadInputs.DEADZONE_GROUPS);
    }

    protected void method_25426() {
        this.goBackButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"controlify.gui.mapping_maker.go_back"), button -> this.goBackStage()).method_46434(this.field_22789 / 2 - 152, this.field_22790 - 60, 150, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"controlify.gui.mapping_maker.go_back.tooltip"))).method_46431();
        this.method_37063((class_364)this.goBackButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"controlify.gui.mapping_maker.no_map"), button -> this.mapAsNone()).method_46434(this.field_22789 / 2 + 2, this.field_22790 - 60, 150, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"controlify.gui.mapping_maker.no_map.tooltip"))).method_46431());
        this.goBackButton.field_22763 = false;
    }

    public void method_25393() {
        if (this.delayTillNextStage >= 0) {
            --this.delayTillNextStage;
            if (this.delayTillNextStage == -1) {
                if (this.currentStage == null) {
                    this.setStage(this.stages.get(0));
                } else {
                    int index = this.stages.indexOf(this.currentStage);
                    int nextIndex = index + 1;
                    if (nextIndex >= this.stages.size()) {
                        this.method_25419();
                    } else {
                        this.setStage(this.stages.get(index + 1));
                        this.goBackButton.field_22763 = true;
                    }
                }
            }
        } else {
            if (this.currentStage == null) {
                this.setStage(this.stages.get(0));
            } else if (this.currentStage.isSatisfied() && this.delayTillNextStage == -1) {
                this.delayTillNextStage = 20;
            }
            if (this.currentStage != null && !this.currentStage.isSatisfied()) {
                ControllerStateView stateNow = this.inputComponent.stateNow();
                ControllerStateView stateThen = this.inputComponent.stateThen();
                this.processStage(this.currentStage, stateNow, stateThen);
            }
        }
    }

    private void processStage(MappingStage stage, ControllerStateView stateNow, ControllerStateView stateThen) {
        for (class_2960 button : stateNow.getButtons()) {
            boolean prev;
            boolean now = stateNow.isButtonDown(button);
            if (now == (prev = stateThen.isButtonDown(button))) continue;
            Record mapping = switch (stage.outputType()) {
                default -> throw new MatchException(null, null);
                case MapType.BUTTON -> new MappingEntry.FromButton.ToButton(button, stage.originInput(), !now);
                case MapType.AXIS -> new MappingEntry.FromButton.ToAxis(button, stage.originInput(), prev ? 1.0f : 0.0f, now ? 1.0f : 0.0f);
                case MapType.HAT -> {
                    HatState state = now ? HatState.DOWN : HatState.UP;
                    yield new MappingEntry.FromButton.ToHat(button, stage.originInput(), HatState.CENTERED, state);
                }
                case MapType.NOTHING -> null;
            };
            this.mappingBuilder.putMapping((MappingEntry)((Object)mapping));
            stage.setSatisfied(true);
            return;
        }
        for (class_2960 axis : stateNow.getAxes()) {
            float now = stateNow.getAxisState(axis);
            float prev = stateThen.getAxisState(axis);
            float diff = prev - now;
            if (!(Math.abs(diff) > 0.3f)) continue;
            Record mapping = switch (stage.outputType()) {
                default -> throw new MatchException(null, null);
                case MapType.BUTTON -> new MappingEntry.FromAxis.ToButton(axis, stage.originInput(), 0.5f);
                case MapType.AXIS -> new MappingEntry.FromAxis.ToAxis(axis, stage.originInput(), 0.0f, 0.0f, 1.0f, 1.0f);
                case MapType.HAT -> new MappingEntry.FromAxis.ToHat(axis, stage.originInput(), 0.5f, diff > 0.0f ? HatState.UP : HatState.DOWN);
                case MapType.NOTHING -> null;
            };
            this.mappingBuilder.putMapping((MappingEntry)((Object)mapping));
            stage.setSatisfied(true);
            return;
        }
        for (class_2960 hat : stateNow.getHats()) {
            HatState prev;
            HatState now = stateNow.getHatState(hat);
            if (now == (prev = stateThen.getHatState(hat))) continue;
            Record mapping = switch (stage.outputType()) {
                default -> throw new MatchException(null, null);
                case MapType.BUTTON -> new MappingEntry.FromHat.ToButton(hat, stage.originInput(), now);
                case MapType.AXIS -> new MappingEntry.FromHat.ToAxis(hat, stage.originInput(), now, 0.0f, 1.0f);
                case MapType.HAT -> new MappingEntry.FromHat.ToHat(hat, stage.originInput());
                case MapType.NOTHING -> null;
            };
            this.mappingBuilder.putMapping((MappingEntry)((Object)mapping));
            stage.setSatisfied(true);
            return;
        }
    }

    private void setStage(MappingStage stage) {
        this.currentStage = stage;
    }

    private void mapAsNone() {
        Record mapping = switch (this.currentStage.outputType()) {
            default -> throw new MatchException(null, null);
            case MapType.BUTTON -> new MappingEntry.FromNothing.ToButton(this.currentStage.originInput(), false);
            case MapType.AXIS -> new MappingEntry.FromNothing.ToAxis(this.currentStage.originInput(), 0.0f);
            case MapType.HAT -> new MappingEntry.FromNothing.ToHat(this.currentStage.originInput());
            case MapType.NOTHING -> null;
        };
        this.mappingBuilder.putMapping((MappingEntry)((Object)mapping));
        this.delayTillNextStage = 0;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
        ((InputComponent.Config)this.inputComponent.confObj()).mapping = this.mappingBuilder.build();
        Controlify.instance().config().save();
    }

    private void goBackStage() {
        int index = this.stages.indexOf(this.currentStage);
        int nextIndex = index - 1;
        if (nextIndex >= 0) {
            this.setStage(this.stages.get(index - 1));
            this.currentStage.setSatisfied(false);
        }
        this.goBackButton.field_22763 = nextIndex > 0;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        float colour;
        super.method_25394(guiGraphics, i, j, f);
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"controlify.gui.mapping_maker.title"), this.field_22789 / 2, 15, 0xFFFFFF);
        guiGraphics.method_27534(this.field_22793, (class_2561)(this.currentStage == null ? class_2561.method_43471((String)"controlify.gui.mapping_maker.please_wait") : this.currentStage.name()), this.field_22789 / 2, this.field_22790 - 20, 0xFFFFFF);
        int safeZone = Math.min(this.field_22789, this.field_22790) - 30;
        float scale = (float)safeZone / 32.0f;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, -5.0f, 0.0f);
        guiGraphics.method_51448().method_46416(-32.0f * scale / 2.0f, 0.0f, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        float f2 = colour = this.currentStage != null && this.currentStage.isSatisfied() ? 0.46f : 1.0f;
        if (this.currentStage != null && this.currentStage.background() != null) {
            Blit.blitTex(guiGraphics, this.currentStage.background(), 0, 0, 0.0f, 0.0f, 32, 32, 32, 32, ColorUtils.grey(colour, 1.0f));
        }
        if (this.currentStage == null || !this.currentStage.isSatisfied()) {
            class_2960 texture = this.currentStage != null ? this.currentStage.foreground() : CUtil.rl("textures/gui/controllerdiagram/faceview.png");
            Blit.blitTex(guiGraphics, texture, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32, ColorUtils.grey(colour, 1.0f));
        }
        guiGraphics.method_51448().method_22909();
        float progress = this.currentStage != null ? (float)(this.stages.indexOf(this.currentStage) + 1) / (float)this.stages.size() : 0.0f;
        ClientUtils.drawBar(guiGraphics, this.field_22789 / 2, this.field_22790 - 30, progress);
    }

    private static class_2561 button(String buttonName) {
        return class_2561.method_43469((String)"controlify.gui.mapping_maker.instruction.button", (Object[])new Object[]{class_2561.method_43471((String)("controlify.gui.mapping_maker.instruction." + buttonName))});
    }

    private static class_2561 axis(String axisName, boolean horizontal) {
        class_5250 axis = class_2561.method_43471((String)("controlify.gui.mapping_maker.instruction." + axisName));
        return horizontal ? class_2561.method_43469((String)"controlify.gui.mapping_maker.instruction.axis_x", (Object[])new Object[]{axis}) : class_2561.method_43469((String)"controlify.gui.mapping_maker.instruction.axis_y", (Object[])new Object[]{axis});
    }

    @Override
    public ScreenProcessor<?> screenProcessor() {
        return this.screenProcessor;
    }

    private static class ScreenProcessorImpl
    extends ScreenProcessor<ControllerMappingMakerScreen> {
        public ScreenProcessorImpl(ControllerMappingMakerScreen screen) {
            super(screen);
        }

        @Override
        public void onControllerUpdate(ControllerEntity controller) {
        }
    }

    public static class MappingStage {
        private final class_2960 originInput;
        private final MapType outputType;
        private final class_2561 name;
        private final class_2960 foreground;
        private final class_2960 background;
        private boolean satisfied;

        public MappingStage(class_2960 originInput, MapType outputType, class_2561 name, String foreground, String background) {
            this.originInput = originInput;
            this.outputType = outputType;
            this.name = name;
            this.foreground = CUtil.rl("textures/gui/controllerdiagram/" + foreground + ".png");
            this.background = CUtil.rl("textures/gui/controllerdiagram/" + foreground + ".png");
        }

        public class_2960 originInput() {
            return this.originInput;
        }

        public MapType outputType() {
            return this.outputType;
        }

        public class_2561 name() {
            return this.name;
        }

        public class_2960 foreground() {
            return this.foreground;
        }

        public class_2960 background() {
            return this.background;
        }

        public boolean isSatisfied() {
            return this.satisfied;
        }

        public void setSatisfied(boolean satisfied) {
            this.satisfied = satisfied;
        }
    }
}

