/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.controllers;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.ControlifyVertexConsumer;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class Deadzone2DImageRenderer
implements ImageRenderer {
    private final InputComponent input;
    private final DeadzoneGroup deadzoneGroup;
    private final Supplier<Option<Float>> deadzoneOption;

    public Deadzone2DImageRenderer(InputComponent input, DeadzoneGroup deadzoneGroup, Supplier<Option<Float>> deadzoneOption) {
        this.input = input;
        this.deadzoneGroup = deadzoneGroup;
        this.deadzoneOption = deadzoneOption;
    }

    public int render(class_332 graphics, int x, int y, int renderWidth, float tickDelta) {
        float radius = (float)renderWidth / 4.0f;
        int renderHeight = (int)(radius * 2.0f);
        List<class_2960> deadzones = this.deadzoneGroup.axes();
        float up = this.input.rawStateNow().getAxisState(deadzones.get(0));
        float down = this.input.rawStateNow().getAxisState(deadzones.get(1));
        float left = this.input.rawStateNow().getAxisState(deadzones.get(2));
        float right = this.input.rawStateNow().getAxisState(deadzones.get(3));
        float currentX = right - left;
        float currentY = down - up;
        graphics.method_25292(x, (int)((float)x + radius * 2.0f), (int)((float)y + radius), -5592406);
        graphics.method_25301((int)((float)x + radius), y, (int)((float)y + radius * 2.0f), -5592406);
        Deadzone2DImageRenderer.drawCircleOutline(graphics.method_51448(), (float)x + radius, (float)y + radius, 0.0f, radius, 1.0f, -1, 360);
        float deadzone = ((Float)this.deadzoneOption.get().pendingValue()).floatValue();
        boolean aboveDeadzone = Math.abs(currentX) > deadzone || Math.abs(currentY) > deadzone;
        Deadzone2DImageRenderer.drawCircleOutline(graphics.method_51448(), (float)x + radius, (float)y + radius, 0.0f, deadzone * radius, 1.0f, aboveDeadzone ? -16711681 : -65536, 360);
        Deadzone2DImageRenderer.drawCircle(graphics.method_51448(), (float)x + radius + currentX * radius, (float)y + radius + currentY * radius, 0.0f, 1.0f, -16711936, 360);
        class_327 font = class_310.method_1551().field_1772;
        DecimalFormat format = new DecimalFormat("0.000");
        graphics.method_25303(font, "X: " + format.format(currentX), (int)((float)x + radius * 2.0f + 5.0f), y, -1);
        String string = "Y: " + format.format(currentY);
        int n = (int)((float)x + radius * 2.0f + 5.0f);
        Objects.requireNonNull(font);
        graphics.method_25303(font, string, n, y + 9 + 1, -1);
        return renderHeight;
    }

    public void close() {
    }

    private static void drawCircle(class_4587 poseStack, float originX, float originY, float z, float radius, int colour, int segments) {
        class_287 buffer = CUtil.beginBuffer(class_293.class_5596.field_27381, class_290.field_1576);
        ControlifyVertexConsumer consumer = ControlifyVertexConsumer.of((class_4588)buffer);
        Matrix4f position = poseStack.method_23760().method_23761();
        for (int i = 0; i < 360; i += (int)Math.min(360.0 / (double)segments, (double)(360 - i))) {
            float radians = (float)i * ((float)Math.PI / 180);
            float x = originX + class_3532.method_15374((float)radians) * radius;
            float y = originY + class_3532.method_15362((float)radians) * radius;
            consumer.vertex(position, x, y, z).color(colour).endVertex();
        }
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        Blit.setPosColorShader();
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
    }

    private static void drawCircleOutline(class_4587 poseStack, float originX, float originY, float z, float radius, float thickness, int colour, int segments) {
        class_287 buffer = CUtil.beginBuffer(class_293.class_5596.field_27380, class_290.field_1576);
        ControlifyVertexConsumer vertexConsumer = ControlifyVertexConsumer.of((class_4588)buffer);
        Matrix4f position = poseStack.method_23760().method_23761();
        float diff = radius - thickness;
        for (int i = 0; i <= segments; ++i) {
            float radians = (float)i / (float)segments * 360.0f * ((float)Math.PI / 180);
            float sin = class_3532.method_15374((float)radians);
            float cos = class_3532.method_15362((float)radians);
            float x1 = originX + sin * diff;
            float y1 = originY + cos * diff;
            vertexConsumer.vertex(position, x1, y1, z).color(colour);
            float x2 = originX + sin * radius;
            float y2 = originY + cos * radius;
            vertexConsumer.vertex(position, x2, y2, z).color(colour);
        }
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        Blit.setPosColorShader();
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
    }
}

