/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controller.impl.ControllerStateImpl;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.input.JoystickInputs;
import dev.isxander.controlify.driver.sdl.SDLCommonDriver;
import dev.isxander.sdl3java.api.joystick.SDL_Joystick;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickGUID;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickID;
import dev.isxander.sdl3java.api.joystick.SdlJoystick;
import dev.isxander.sdl3java.api.properties.SDL_PropertiesID;
import java.util.Set;
import net.minecraft.class_3532;

public class SDL3JoystickDriver
extends SDLCommonDriver<SDL_Joystick> {
    private InputComponent inputComponent;
    private final int numAxes;
    private final int numButtons;
    private final int numHats;

    public SDL3JoystickDriver(SDL_Joystick ptrJoystick, SDL_JoystickID jid, ControllerType type) {
        super(ptrJoystick, jid, type);
        this.numAxes = SdlJoystick.SDL_GetNumJoystickAxes((SDL_Joystick)ptrJoystick);
        this.numButtons = SdlJoystick.SDL_GetNumJoystickButtons((SDL_Joystick)ptrJoystick);
        this.numHats = SdlJoystick.SDL_GetNumJoystickHats((SDL_Joystick)ptrJoystick);
    }

    @Override
    public void addComponents(ControllerEntity controller) {
        super.addComponents(controller);
        this.inputComponent = new InputComponent(controller, this.numButtons, this.numAxes * 2, this.numHats, false, Set.of(), controller.info().type().mappingId());
        controller.setComponent(this.inputComponent);
    }

    @Override
    public void update(ControllerEntity controller, boolean outOfFocus) {
        super.update(controller, outOfFocus);
        this.updateInput();
    }

    private void updateInput() {
        int i;
        ControllerStateImpl state = new ControllerStateImpl();
        for (i = 0; i < this.numAxes; ++i) {
            float axis = SDL3JoystickDriver.mapShortToFloat(SdlJoystick.SDL_GetJoystickAxis((SDL_Joystick)((SDL_Joystick)this.ptrController), (int)i));
            state.setAxis(JoystickInputs.axis(i, true), Math.max(axis, 0.0f));
            state.setAxis(JoystickInputs.axis(i, false), -Math.min(axis, 0.0f));
        }
        for (i = 0; i < this.numButtons; ++i) {
            state.setButton(JoystickInputs.button(i), SdlJoystick.SDL_GetJoystickButton((SDL_Joystick)((SDL_Joystick)this.ptrController), (int)i) == 1);
        }
        for (i = 0; i < this.numHats; ++i) {
            HatState hatState = switch (SdlJoystick.SDL_GetJoystickHat((SDL_Joystick)((SDL_Joystick)this.ptrController), (int)i)) {
                case 0 -> HatState.CENTERED;
                case 1 -> HatState.UP;
                case 2 -> HatState.RIGHT;
                case 4 -> HatState.DOWN;
                case 8 -> HatState.LEFT;
                case 3 -> HatState.RIGHT_UP;
                case 6 -> HatState.RIGHT_DOWN;
                case 9 -> HatState.LEFT_UP;
                case 12 -> HatState.LEFT_DOWN;
                default -> throw new IllegalStateException("Unexpected value: " + SdlJoystick.SDL_GetJoystickHat((SDL_Joystick)((SDL_Joystick)this.ptrController), (int)i));
            };
            state.setHat(JoystickInputs.hat(i), hatState);
        }
        this.inputComponent.pushState(state);
    }

    private static float mapShortToFloat(short value) {
        return class_3532.method_37958((float)value, (float)-32768.0f, (float)0.0f, (float)-1.0f, (float)0.0f) + class_3532.method_37958((float)value, (float)0.0f, (float)32767.0f, (float)0.0f, (float)1.0f);
    }

    @Override
    protected SDL_PropertiesID SDL_GetControllerProperties(SDL_Joystick ptrController) {
        return SdlJoystick.SDL_GetJoystickProperties((SDL_Joystick)ptrController);
    }

    @Override
    protected String SDL_GetControllerName(SDL_Joystick ptrController) {
        return SdlJoystick.SDL_GetJoystickName((SDL_Joystick)ptrController);
    }

    @Override
    protected SDL_JoystickGUID SDL_GetControllerGUIDForID(SDL_JoystickID jid) {
        return SdlJoystick.SDL_GetJoystickGUIDForID((SDL_JoystickID)jid);
    }

    @Override
    protected String SDL_GetControllerSerial(SDL_Joystick ptrController) {
        return SdlJoystick.SDL_GetJoystickSerial((SDL_Joystick)ptrController);
    }

    @Override
    protected boolean SDL_CloseController(SDL_Joystick ptrController) {
        SdlJoystick.SDL_CloseJoystick((SDL_Joystick)ptrController);
        return true;
    }

    @Override
    protected boolean SDL_RumbleController(SDL_Joystick ptrController, float strong, float weak, int durationMs) {
        return SdlJoystick.SDL_RumbleJoystick((SDL_Joystick)ptrController, (short)((short)(strong * 65535.0f)), (short)((short)(weak * 65535.0f)), (int)durationMs);
    }

    @Override
    protected boolean SDL_RumbleControllerTriggers(SDL_Joystick ptrController, float left, float right, int durationMs) {
        return SdlJoystick.SDL_RumbleJoystickTriggers((SDL_Joystick)ptrController, (short)((short)(left * 65535.0f)), (short)((short)(right * 65535.0f)), (int)durationMs);
    }

    @Override
    protected int SDL_GetControllerPowerInfo(SDL_Joystick ptrController, IntByReference percent) {
        return SdlJoystick.SDL_GetJoystickPowerInfo((SDL_Joystick)ptrController, (IntByReference)percent);
    }

    @Override
    protected boolean SDL_SendControllerEffect(SDL_Joystick ptrController, Pointer effect, int size) {
        return SdlJoystick.SDL_SendJoystickEffect((SDL_Joystick)ptrController, (Pointer)effect, (int)size);
    }
}

