/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controllermanager;

import com.google.common.io.ByteStreams;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.ControllerInfo;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controllermanager.AbstractControllerManager;
import dev.isxander.controlify.controllermanager.UniqueControllerID;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.driver.SDL3NativesManager;
import dev.isxander.controlify.driver.sdl.SDL3GamepadDriver;
import dev.isxander.controlify.driver.sdl.SDL3JoystickDriver;
import dev.isxander.controlify.driver.sdl.SDLUtil;
import dev.isxander.controlify.driver.steamdeck.SteamDeckDriver;
import dev.isxander.controlify.driver.steamdeck.SteamDeckUtil;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.hid.HIDIdentifier;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.sdl3java.api.error.SdlError;
import dev.isxander.sdl3java.api.events.SDL_EventFilter;
import dev.isxander.sdl3java.api.events.SdlEvents;
import dev.isxander.sdl3java.api.events.events.SDL_Event;
import dev.isxander.sdl3java.api.gamepad.SDL_Gamepad;
import dev.isxander.sdl3java.api.gamepad.SdlGamepad;
import dev.isxander.sdl3java.api.iostream.SDL_IOStream;
import dev.isxander.sdl3java.api.iostream.SdlIOStream;
import dev.isxander.sdl3java.api.joystick.SDL_Joystick;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickGUID;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickID;
import dev.isxander.sdl3java.api.joystick.SdlJoystick;
import dev.isxander.sdl3java.jna.size_t;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SDLControllerManager
extends AbstractControllerManager {
    private SDL_Event event = new SDL_Event();
    private final EventFilter eventFilter;
    private boolean steamDeckConsumed = false;

    public SDLControllerManager() {
        Validate.isTrue((boolean)SDL3NativesManager.isLoaded(), (String)"SDL3 natives must be loaded before creating SDLControllerManager", (Object[])new Object[0]);
        this.eventFilter = new EventFilter();
        SdlEvents.SDL_SetEventFilter((SDL_EventFilter)this.eventFilter, (Pointer)Pointer.NULL);
    }

    @Override
    public void tick(boolean outOfFocus) {
        super.tick(outOfFocus);
        SdlEvents.SDL_PumpEvents();
        if (this.event == null) {
            CUtil.LOGGER.error("EVENT WAS NULL SOMEHOW!! RECONSTRUCTING");
            this.event = new SDL_Event();
        }
        while (SdlEvents.SDL_PollEvent((SDL_Event)this.event)) {
            switch (this.event.type) {
                case 1541: {
                    SDL_JoystickID jid = this.event.jdevice.which;
                    Validate.notNull((Object)jid, (String)"JID was null", (Object[])new Object[0]);
                    SDLUniqueControllerID ucid = new SDLUniqueControllerID(jid);
                    Optional<ControllerEntity> controllerOpt = this.tryCreate(ucid, SDLControllerManager.fetchTypeFromSDL(jid).orElse(new ControllerHIDService.ControllerHIDInfo(ControllerType.DEFAULT, Optional.empty())));
                    controllerOpt.ifPresent(controller -> ControllerUtils.wrapControllerError(() -> this.onControllerConnected((ControllerEntity)controller, true), "Connecting controller", controller));
                    break;
                }
                case 1542: {
                    SDL_JoystickID jid = this.event.jdevice.which;
                    Validate.notNull((Object)jid, (String)"JID was null", (Object[])new Object[0]);
                    this.getController(new SDLUniqueControllerID(jid)).ifPresentOrElse(this::onControllerRemoved, () -> CUtil.LOGGER.warn("Controller removed but not found: {}", (Object)jid.intValue()));
                }
            }
        }
        SdlGamepad.SDL_UpdateGamepads();
        SdlJoystick.SDL_UpdateJoysticks();
    }

    @Override
    public void discoverControllers() {
        SDL_JoystickID[] joysticks;
        for (SDL_JoystickID jid : joysticks = SdlJoystick.SDL_GetJoysticks()) {
            Optional<ControllerEntity> controllerOpt = this.tryCreate(new SDLUniqueControllerID(jid), SDLControllerManager.fetchTypeFromSDL(jid).orElse(new ControllerHIDService.ControllerHIDInfo(ControllerType.DEFAULT, Optional.empty())));
            controllerOpt.ifPresent(controller -> this.onControllerConnected((ControllerEntity)controller, false));
        }
    }

    @Override
    protected Optional<ControllerEntity> createController(UniqueControllerID ucid, ControllerHIDService.ControllerHIDInfo hidInfo) {
        Optional<SteamDeckDriver> steamDeckDriver;
        SDL_JoystickID jid = ((SDLUniqueControllerID)ucid).jid;
        Optional<HIDIdentifier> hid = hidInfo.hidDevice().map(HIDDevice::asIdentifier);
        boolean isGamepad = this.isControllerGamepad(ucid) && !DebugProperties.FORCE_JOYSTICK;
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        if (SteamDeckUtil.DECK_MODE.isGamingMode() && !this.steamDeckConsumed && hidInfo.type().namespace().equals((Object)SteamDeckUtil.STEAM_DECK_NAMESPACE) && (steamDeckDriver = SteamDeckDriver.create()).isPresent()) {
            drivers.add(steamDeckDriver.get());
            this.steamDeckConsumed = true;
        }
        String uid = hidInfo.createControllerUID(this.getControllerCountWithMatchingHID(hid.orElse(null))).orElse("unknown-uid-" + String.valueOf(ucid));
        if (isGamepad) {
            SDL_Gamepad ptrGamepad = SDLUtil.openGamepad(jid);
            if (DebugProperties.SDL_USE_SERIAL_FOR_UID) {
                uid = SDLControllerManager.useSerialForUID(SdlGamepad.SDL_GetGamepadSerial((SDL_Gamepad)ptrGamepad), hid).orElse(uid);
            }
            drivers.add(new SDL3GamepadDriver(ptrGamepad, jid, hidInfo.type()));
        } else {
            SDL_Joystick ptrJoystick = SDLUtil.openJoystick(jid);
            if (DebugProperties.SDL_USE_SERIAL_FOR_UID) {
                uid = SDLControllerManager.useSerialForUID(SdlJoystick.SDL_GetJoystickSerial((SDL_Joystick)ptrJoystick), hid).orElse(uid);
            }
            drivers.add(new SDL3JoystickDriver(ptrJoystick, jid, hidInfo.type()));
        }
        String name = ((Driver)drivers.get(0)).getDriverName();
        String guid = SdlJoystick.SDL_GetJoystickGUIDForID((SDL_JoystickID)jid).toString();
        ControllerInfo info = new ControllerInfo(uid, ucid, guid, name, hidInfo.type(), hidInfo.hidDevice());
        ControllerEntity controller = new ControllerEntity(info, drivers);
        this.addController(ucid, controller);
        return Optional.of(controller);
    }

    @Override
    public boolean probeConnectedControllers() {
        return SdlJoystick.SDL_HasJoystick() || SdlGamepad.SDL_HasGamepad();
    }

    @Override
    public boolean isControllerGamepad(UniqueControllerID ucid) {
        SDL_JoystickID jid = ((SDLUniqueControllerID)ucid).jid;
        return SdlGamepad.SDL_IsGamepad((SDL_JoystickID)jid);
    }

    @Override
    protected String getControllerSystemName(UniqueControllerID ucid) {
        SDL_JoystickID jid = ((SDLUniqueControllerID)ucid).jid;
        return this.isControllerGamepad(ucid) ? SdlGamepad.SDL_GetGamepadNameForID((SDL_JoystickID)jid) : SdlJoystick.SDL_GetJoystickNameForID((SDL_JoystickID)jid);
    }

    private Optional<ControllerEntity> getController(UniqueControllerID ucid) {
        return Optional.ofNullable(this.controllersByJid.getOrDefault(ucid, null));
    }

    @Override
    protected void loadGamepadMappings(class_5912 resourceProvider) {
        CUtil.LOGGER.debug("Loading gamepad mappings...");
        Optional resourceOpt = resourceProvider.method_14486(CUtil.rl("controllers/gamecontrollerdb-sdl3.txt"));
        if (resourceOpt.isEmpty()) {
            CUtil.LOGGER.error("Failed to find game controller database.");
            return;
        }
        try (InputStream is = ((class_3298)resourceOpt.get()).method_14482();){
            byte[] bytes = ByteStreams.toByteArray((InputStream)is);
            try (Memory memory = new Memory((long)bytes.length);){
                memory.write(0L, bytes, 0, bytes.length);
                SDL_IOStream stream = SdlIOStream.SDL_IOFromConstMem((Pointer)memory, (size_t)new size_t((long)bytes.length));
                if (stream == null) {
                    throw new IllegalStateException("Failed to open stream");
                }
                int count = SdlGamepad.SDL_AddGamepadMappingsFromIO((SDL_IOStream)stream, (boolean)true);
                if (count < 0) {
                    CUtil.LOGGER.error("Failed to load gamepad mappings: {}", (Object)SdlError.SDL_GetError());
                } else if (count == 0) {
                    CUtil.LOGGER.warn("Successfully applied gamepad mappings but none were found for this platform. Unsupported OS?");
                } else {
                    CUtil.LOGGER.info("Successfully loaded {} gamepad mapping entries!", (Object)count);
                }
            }
        }
        catch (Throwable e) {
            CUtil.LOGGER.error("Failed to load gamepad mappings", e);
        }
    }

    private static Optional<ControllerHIDService.ControllerHIDInfo> fetchTypeFromSDL(SDL_JoystickID jid) {
        short vid = SdlJoystick.SDL_GetJoystickVendorForID((SDL_JoystickID)jid);
        short pid = SdlJoystick.SDL_GetJoystickProductForID((SDL_JoystickID)jid);
        SDL_JoystickGUID guid = SdlJoystick.SDL_GetJoystickGUIDForID((SDL_JoystickID)jid);
        String guidStr = guid.toString();
        if (vid != 0 && pid != 0) {
            CUtil.LOGGER.info("Using SDL to identify controller type.");
            return Optional.of(new ControllerHIDService.ControllerHIDInfo(Controlify.instance().controllerTypeManager().getControllerType(new HIDIdentifier(vid, pid)), Optional.of(new HIDDevice.SDLHidApi(vid, pid, guidStr))));
        }
        return Optional.empty();
    }

    private static Optional<String> useSerialForUID(@Nullable String serial, Optional<HIDIdentifier> hid) {
        if (serial != null && !serial.isEmpty()) {
            Object uid = "";
            if (hid.isPresent()) {
                HexFormat hex = HexFormat.of();
                HIDIdentifier hidIdentifier = hid.get();
                uid = "V" + hex.toHexDigits(hidIdentifier.vendorId(), 4).toUpperCase() + "-P" + hex.toHexDigits(hidIdentifier.productId(), 4).toUpperCase() + "-";
            }
            uid = (String)uid + "SN" + serial.toUpperCase();
            return Optional.of(uid);
        }
        return Optional.empty();
    }

    private static class EventFilter
    implements SDL_EventFilter {
        private EventFilter() {
        }

        public boolean filterEvent(Pointer userdata, SDL_Event event) {
            switch (event.type) {
                case 1541: 
                case 1542: {
                    return true;
                }
            }
            return false;
        }
    }

    public record SDLUniqueControllerID(@NotNull SDL_JoystickID jid) implements UniqueControllerID
    {
        @Override
        public boolean equals(Object obj) {
            return obj instanceof SDLUniqueControllerID && ((SDLUniqueControllerID)obj).jid.equals((Object)this.jid);
        }

        @Override
        public String toString() {
            return "SDL-" + this.jid.longValue();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.jid.longValue());
        }
    }
}

