/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.input;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.ControlifyBindApiImpl;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.ECSComponent;
import dev.isxander.controlify.controller.impl.ConfigImpl;
import dev.isxander.controlify.controller.input.ControllerState;
import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.controller.input.DeadzoneControllerStateView;
import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.mapping.ControllerMapping;
import dev.isxander.controlify.controller.input.mapping.ControllerMappingStorage;
import dev.isxander.controlify.controller.serialization.ConfigClass;
import dev.isxander.controlify.controller.serialization.ConfigHolder;
import dev.isxander.controlify.controller.serialization.CustomSaveLoadConfig;
import dev.isxander.controlify.controller.serialization.IConfig;
import dev.isxander.controlify.gui.screen.RadialMenuScreen;
import dev.isxander.controlify.utils.CUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class InputComponent
implements ECSComponent,
ConfigHolder<Config>,
CustomSaveLoadConfig {
    public static final class_2960 ID = CUtil.rl("input");
    private final ControllerEntity controller;
    private ControllerState stateNow = ControllerState.EMPTY;
    private ControllerState stateThen = ControllerState.EMPTY;
    private DeadzoneControllerStateView deadzoneStateNow;
    private DeadzoneControllerStateView deadzoneStateThen;
    private final int buttonCount;
    private final int axisCount;
    private final int hatCount;
    private final Map<class_2960, DeadzoneGroup> deadzoneAxes;
    private final boolean definitelyGamepad;
    private final Map<class_2960, InputBinding> inputBindings;
    private final IConfig<Config> config;

    public InputComponent(ControllerEntity controller, int buttonCount, int axisCount, int hatCount, boolean definitelyGamepad, Set<DeadzoneGroup> deadzoneAxes, String mappingId) {
        this.controller = controller;
        this.buttonCount = buttonCount;
        this.axisCount = axisCount;
        this.hatCount = hatCount;
        this.config = new ConfigImpl<Config>(() -> new Config(ControllerMappingStorage.get(mappingId)), Config.class, this);
        this.definitelyGamepad = definitelyGamepad;
        this.deadzoneAxes = deadzoneAxes.stream().collect(Collectors.toMap(DeadzoneGroup::name, Function.identity(), (x, y) -> y, LinkedHashMap::new));
        this.inputBindings = new LinkedHashMap<class_2960, InputBinding>();
        this.updateDeadzoneView();
    }

    public ControllerStateView stateNow() {
        return this.deadzoneStateNow;
    }

    public ControllerStateView stateThen() {
        return this.deadzoneStateThen;
    }

    public ControllerState rawStateNow() {
        return this.stateNow;
    }

    public ControllerState rawStateThen() {
        return this.stateThen;
    }

    public void pushState(ControllerState state) {
        ControllerMapping mapping = ((Config)this.confObj()).mapping;
        if (mapping != null) {
            state = mapping.mapState(state);
        }
        this.stateThen = this.stateNow;
        this.stateNow = state;
        this.updateDeadzoneView();
        for (InputBinding binding : this.inputBindings.values()) {
            binding.pushState(this.deadzoneStateNow);
        }
    }

    @Nullable
    public InputBinding getBinding(class_2960 id) {
        return this.inputBindings.get(id);
    }

    public Collection<InputBinding> getAllBindings() {
        return this.inputBindings.values();
    }

    public void notifyGuiPressOutputsOfNavigate() {
        for (InputBinding binding : this.inputBindings.values()) {
            binding.guiPressed().onNavigate();
        }
    }

    @Override
    public void finalise() {
        for (InputBinding binding : ControlifyBindApiImpl.INSTANCE.provideBindsForController(this.controller)) {
            this.inputBindings.put(binding.id(), binding);
        }
    }

    public int buttonCount() {
        return this.buttonCount;
    }

    public int axisCount() {
        return this.axisCount;
    }

    public int hatCount() {
        return this.hatCount;
    }

    public boolean isDefinitelyGamepad() {
        return this.definitelyGamepad;
    }

    public Map<class_2960, DeadzoneGroup> getDeadzoneGroups() {
        ControllerMapping mapping = ((Config)this.confObj()).mapping;
        if (mapping != null) {
            return mapping.deadzones();
        }
        return this.deadzoneAxes;
    }

    @Override
    public IConfig<Config> config() {
        return this.config;
    }

    @Override
    public class_2960 id() {
        return ID;
    }

    private void updateDeadzoneView() {
        this.deadzoneStateNow = new DeadzoneControllerStateView(this.stateNow, this);
        this.deadzoneStateThen = new DeadzoneControllerStateView(this.stateThen, this);
    }

    Optional<class_2960> getDeadzoneForAxis(class_2960 axis) {
        for (DeadzoneGroup group : this.getDeadzoneGroups().values()) {
            if (!group.axes().contains(axis)) continue;
            return Optional.of(group.name());
        }
        return Optional.empty();
    }

    @Override
    public void toJson(JsonObject json) {
        JsonObject innerJson = new JsonObject();
        for (InputBinding binding : this.inputBindings.values()) {
            if (!((Config)this.confObj()).keepDefaultBindings && binding.boundInput().equals(binding.defaultInput())) continue;
            try {
                innerJson.add(binding.id().toString(), (JsonElement)Input.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)binding.boundInput()).result().orElseThrow());
            }
            catch (Exception e) {
                CUtil.LOGGER.error("Failed to serialize input binding {}", (Object)binding.id(), (Object)e);
            }
        }
        json.add("bindings", (JsonElement)innerJson);
    }

    @Override
    public void fromJson(JsonObject json) {
        if (!json.has("bindings")) {
            CUtil.LOGGER.warn("Could not find bindings in json, upgrading from older version?");
            return;
        }
        JsonObject innerJson = json.getAsJsonObject("bindings");
        for (InputBinding binding : this.inputBindings.values()) {
            JsonElement element = innerJson.get(binding.id().toString());
            if (element == null) continue;
            try {
                Input input = (Input)Input.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).result().orElseThrow();
                binding.setBoundInput(input);
            }
            catch (Exception e) {
                CUtil.LOGGER.error("Failed to deserialize input binding {}. Using default.", (Object)binding.id(), (Object)e);
            }
        }
    }

    public static class Config
    implements ConfigClass {
        public float hLookSensitivity = 1.0f;
        public float vLookSensitivity = 0.9f;
        public float virtualMouseSensitivity = 1.0f;
        public boolean reduceAimingSensitivity = true;
        public float buttonActivationThreshold = 0.5f;
        public Map<class_2960, Float> deadzones = new Object2ObjectOpenHashMap();
        public boolean deadzonesCalibrated = false;
        public boolean delayedCalibration = false;
        public boolean mixedInput = false;
        public boolean keepDefaultBindings = false;
        public class_2960[] radialActions = new class_2960[8];
        public int radialButtonFocusTimeoutTicks = 20;
        @Nullable
        public ControllerMapping mapping = null;

        public Config() {
        }

        public Config(@Nullable ControllerMapping typeProvidedMapping) {
            this.mapping = typeProvidedMapping;
        }

        @Override
        public void onConfigSaveLoad(ControllerEntity controller) {
            this.validateRadialActions(controller);
        }

        private void validateRadialActions(ControllerEntity controller) {
            boolean changed = false;
            for (int i = 0; i < this.radialActions.length; ++i) {
                InputBinding radialBinding;
                class_2960 action = this.radialActions[i];
                InputBinding inputBinding = radialBinding = action != null ? controller.input().orElseThrow().getBinding(action) : null;
                if (RadialMenuScreen.EMPTY_ACTION.equals((Object)action) || radialBinding != null && !radialBinding.radialIcon().isEmpty()) continue;
                this.setDefaultRadialAction(i);
                changed = true;
            }
            if (changed) {
                Controlify.instance().config().setDirty();
            }
        }

        private void setDefaultRadialAction(int index) {
            this.radialActions[index] = switch (index) {
                case 0 -> ControlifyBindings.TOGGLE_HUD_VISIBILITY.bindId();
                case 1 -> ControlifyBindings.CHANGE_PERSPECTIVE.bindId();
                case 2 -> ControlifyBindings.DROP_STACK.bindId();
                case 3 -> ControlifyBindings.OPEN_CHAT.bindId();
                case 4 -> ControlifyBindings.SWAP_HANDS.bindId();
                case 5 -> ControlifyBindings.PICK_BLOCK.bindId();
                case 6 -> ControlifyBindings.TAKE_SCREENSHOT.bindId();
                case 7 -> ControlifyBindings.SHOW_PLAYER_LIST.bindId();
                default -> RadialMenuScreen.EMPTY_ACTION;
            };
        }
    }
}

