/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.Arrays;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.GlintMode;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.mixin.client.indigo.renderer.ItemRendererAccessor;
import net.minecraft.class_10444;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_7837;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ItemRenderContext
extends AbstractRenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private static final int GLINT_COUNT = class_10444.class_10445.values().length;
    private final class_5819 random = class_5819.method_43047();
    private final Supplier<class_5819> randomSupplier = () -> {
        this.random.method_43052(42L);
        return this.random;
    };
    private class_811 transformMode;
    private class_4587 matrixStack;
    private class_4597 vertexConsumerProvider;
    private int lightmap;
    private int[] tints;
    private class_1921 defaultLayer;
    private class_10444.class_10445 defaultGlint;
    private class_4587.class_4665 specialGlintEntry;
    private final class_4588[] vertexConsumerCache = new class_4588[3 * GLINT_COUNT];

    public void render(class_811 transformationMode, class_4587 matrixStack, class_4597 vertexConsumerProvider, int lightmap, int overlay, int[] tints, class_1087 model, class_1921 layer, class_10444.class_10445 glint) {
        this.transformMode = transformationMode;
        this.matrixStack = matrixStack;
        this.vertexConsumerProvider = vertexConsumerProvider;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.tints = tints;
        this.defaultLayer = layer;
        this.defaultGlint = glint;
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        model.emitItemQuads(this.getEmitter(), this.randomSupplier);
        this.matrixStack = null;
        this.vertexConsumerProvider = null;
        this.tints = null;
        this.specialGlintEntry = null;
        Arrays.fill(this.vertexConsumerCache, null);
    }

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad) {
        RenderMaterialImpl mat = quad.material();
        boolean emissive = mat.emissive();
        class_4588 vertexConsumer = this.getVertexConsumer(mat.blendMode(), mat.glintMode());
        this.tintQuad(quad);
        this.shadeQuad(quad, emissive);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        int tintIndex = quad.tintIndex();
        if (tintIndex != -1 && tintIndex < this.tints.length) {
            int tint = this.tints[tintIndex];
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(tint, quad.color(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int lightmap = this.lightmap;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
            }
        }
    }

    private class_4588 getVertexConsumer(BlendMode blendMode, GlintMode glintMode) {
        class_1921 layer = blendMode == BlendMode.DEFAULT ? this.defaultLayer : (blendMode == BlendMode.TRANSLUCENT ? class_4722.method_29382() : class_4722.method_24074());
        class_10444.class_10445 glint = glintMode == GlintMode.DEFAULT ? this.defaultGlint : glintMode.glint;
        int cacheIndex = layer == class_4722.method_29382() ? 0 : (layer == class_4722.method_24074() ? GLINT_COUNT : 2 * GLINT_COUNT);
        class_4588 vertexConsumer = this.vertexConsumerCache[cacheIndex += glint.ordinal()];
        if (vertexConsumer == null) {
            this.vertexConsumerCache[cacheIndex] = vertexConsumer = this.createVertexConsumer(layer, glint);
        }
        return vertexConsumer;
    }

    private class_4588 createVertexConsumer(class_1921 layer, class_10444.class_10445 glint) {
        if (glint == class_10444.class_10445.field_55343) {
            if (this.specialGlintEntry == null) {
                this.specialGlintEntry = this.matrixStack.method_23760().method_56822();
                if (this.transformMode == class_811.field_4317) {
                    class_7837.method_46414((Matrix4f)this.specialGlintEntry.method_23761(), (float)0.5f);
                } else if (this.transformMode.method_29998()) {
                    class_7837.method_46414((Matrix4f)this.specialGlintEntry.method_23761(), (float)0.75f);
                }
            }
            return ItemRendererAccessor.fabric_getDynamicDisplayGlintConsumer(this.vertexConsumerProvider, layer, this.specialGlintEntry);
        }
        return class_918.method_23181((class_4597)this.vertexConsumerProvider, (class_1921)layer, (boolean)true, (glint != class_10444.class_10445.field_55341 ? 1 : 0) != 0);
    }
}

