/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractRenderContext {
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        protected void emitDirectly() {
            AbstractRenderContext.this.bufferQuad(this);
        }
    };
    private final Vector4f posVec = new Vector4f();
    private final Vector3f normalVec = new Vector3f();
    protected Matrix4f matrix;
    protected Matrix3f normalMatrix;
    protected int overlay;

    protected QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    protected abstract void bufferQuad(MutableQuadViewImpl var1);

    protected void bufferQuad(MutableQuadViewImpl quad, class_4588 vertexConsumer) {
        Vector4f posVec = this.posVec;
        Vector3f normalVec = this.normalVec;
        boolean useNormals = quad.hasVertexNormals();
        if (useNormals) {
            quad.populateMissingNormals();
        } else {
            normalVec.set(quad.faceNormal());
            normalVec.mul((Matrix3fc)this.normalMatrix);
        }
        for (int i = 0; i < 4; ++i) {
            posVec.set(quad.x(i), quad.y(i), quad.z(i), 1.0f);
            posVec.mul((Matrix4fc)this.matrix);
            vertexConsumer.method_22912(posVec.x(), posVec.y(), posVec.z());
            int color = quad.color(i);
            vertexConsumer.method_1336(color >>> 16 & 0xFF, color >>> 8 & 0xFF, color & 0xFF, color >>> 24 & 0xFF);
            vertexConsumer.method_22913(quad.u(i), quad.v(i));
            vertexConsumer.method_22922(this.overlay);
            vertexConsumer.method_60803(quad.lightmap(i));
            if (useNormals) {
                quad.copyNormal(i, normalVec);
                normalVec.mul((Matrix3fc)this.normalMatrix);
            }
            vertexConsumer.method_22914(normalVec.x(), normalVec.y(), normalVec.z());
        }
    }
}

