/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.ShadeMode;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.client.indigo.Indigo;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoConfig;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractBlockRenderContext
extends AbstractRenderContext {
    protected final BlockRenderInfo blockInfo = new BlockRenderInfo();
    protected final AoCalculator aoCalc;
    private final class_2338.class_2339 lightPos = new class_2338.class_2339();

    protected AbstractBlockRenderContext() {
        this.aoCalc = this.createAoCalc(this.blockInfo);
    }

    protected abstract AoCalculator createAoCalc(BlockRenderInfo var1);

    protected abstract class_4588 getVertexConsumer(class_1921 var1);

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad) {
        if (this.blockInfo.shouldCullSide(quad.cullFace())) {
            return;
        }
        RenderMaterialImpl mat = quad.material();
        TriState aoMode = mat.ambientOcclusion();
        boolean ao = this.blockInfo.useAo && (aoMode == TriState.TRUE || aoMode == TriState.DEFAULT && this.blockInfo.defaultAo);
        boolean emissive = mat.emissive();
        boolean vanillaShade = mat.shadeMode() == ShadeMode.VANILLA;
        class_4588 vertexConsumer = this.getVertexConsumer(this.blockInfo.effectiveRenderLayer(mat.blendMode()));
        this.tintQuad(quad);
        this.shadeQuad(quad, ao, emissive, vanillaShade);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        int tintIndex = quad.tintIndex();
        if (tintIndex != -1) {
            int blockColor = this.blockInfo.blockColor(tintIndex);
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(blockColor, quad.color(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean ao, boolean emissive, boolean vanillaShade) {
        if (ao) {
            this.aoCalc.compute(quad, vanillaShade);
            if (emissive) {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), this.aoCalc.ao[i]));
                    quad.lightmap(i, 0xF000F0);
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), this.aoCalc.ao[i]));
                    quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), this.aoCalc.light[i]));
                }
            }
        } else {
            this.shadeFlatQuad(quad, vanillaShade);
            if (emissive) {
                for (int i = 0; i < 4; ++i) {
                    quad.lightmap(i, 0xF000F0);
                }
            } else {
                int brightness = this.flatBrightness(quad, this.blockInfo.blockState, this.blockInfo.blockPos);
                for (int i = 0; i < 4; ++i) {
                    quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), brightness));
                }
            }
        }
    }

    private void shadeFlatQuad(MutableQuadViewImpl quad, boolean vanillaShade) {
        block9: {
            boolean hasShade;
            block7: {
                float faceShade;
                block10: {
                    block8: {
                        hasShade = quad.hasShade();
                        if ((Indigo.AMBIENT_OCCLUSION_MODE != AoConfig.HYBRID || vanillaShade) && Indigo.AMBIENT_OCCLUSION_MODE != AoConfig.ENHANCED) break block7;
                        if (!quad.hasAllVertexNormals()) break block8;
                        for (int i = 0; i < 4; ++i) {
                            float shade = this.normalShade(quad.normalX(i), quad.normalY(i), quad.normalZ(i), hasShade);
                            quad.color(i, ColorHelper.multiplyRGB(quad.color(i), shade));
                        }
                        break block9;
                    }
                    if ((quad.geometryFlags() & 2) != 0) {
                        faceShade = this.blockInfo.blockView.method_24852(quad.lightFace(), hasShade);
                    } else {
                        Vector3fc faceNormal = quad.faceNormal();
                        faceShade = this.normalShade(faceNormal.x(), faceNormal.y(), faceNormal.z(), hasShade);
                    }
                    if (!quad.hasVertexNormals()) break block10;
                    for (int i = 0; i < 4; ++i) {
                        float shade = quad.hasNormal(i) ? this.normalShade(quad.normalX(i), quad.normalY(i), quad.normalZ(i), hasShade) : faceShade;
                        quad.color(i, ColorHelper.multiplyRGB(quad.color(i), shade));
                    }
                    break block9;
                }
                if (faceShade == 1.0f) break block9;
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), faceShade));
                }
                break block9;
            }
            float faceShade = this.blockInfo.blockView.method_24852(quad.lightFace(), hasShade);
            if (faceShade != 1.0f) {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), faceShade));
                }
            }
        }
    }

    private float normalShade(float normalX, float normalY, float normalZ, boolean hasShade) {
        float sum = 0.0f;
        float div = 0.0f;
        if (normalX > 0.0f) {
            sum += normalX * this.blockInfo.blockView.method_24852(class_2350.field_11034, hasShade);
            div += normalX;
        } else if (normalX < 0.0f) {
            sum += -normalX * this.blockInfo.blockView.method_24852(class_2350.field_11039, hasShade);
            div -= normalX;
        }
        if (normalY > 0.0f) {
            sum += normalY * this.blockInfo.blockView.method_24852(class_2350.field_11036, hasShade);
            div += normalY;
        } else if (normalY < 0.0f) {
            sum += -normalY * this.blockInfo.blockView.method_24852(class_2350.field_11033, hasShade);
            div -= normalY;
        }
        if (normalZ > 0.0f) {
            sum += normalZ * this.blockInfo.blockView.method_24852(class_2350.field_11035, hasShade);
            div += normalZ;
        } else if (normalZ < 0.0f) {
            sum += -normalZ * this.blockInfo.blockView.method_24852(class_2350.field_11043, hasShade);
            div -= normalZ;
        }
        return sum / div;
    }

    private int flatBrightness(MutableQuadViewImpl quad, class_2680 blockState, class_2338 pos) {
        this.lightPos.method_10101((class_2382)pos);
        if (quad.cullFace() != null) {
            this.lightPos.method_10098(quad.cullFace());
        } else {
            int flags = quad.geometryFlags();
            if ((flags & 4) != 0 || (flags & 2) != 0 && blockState.method_26234((class_1922)this.blockInfo.blockView, pos)) {
                this.lightPos.method_10098(quad.lightFace());
            }
        }
        return class_761.method_23793((class_1920)this.blockInfo.blockView, (class_2680)blockState, (class_2338)this.lightPos);
    }
}

