/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.hid4java.HidDevice;
import org.hid4java.HidDeviceManager;
import org.hid4java.HidException;
import org.hid4java.HidServicesListener;
import org.hid4java.HidServicesSpecification;
import org.hid4java.event.HidServicesListenerList;
import org.hid4java.jna.HidApi;

public class HidServices {
    private final HidServicesListenerList listeners = new HidServicesListenerList();
    private final HidDeviceManager hidDeviceManager;

    public static void main(String[] args) {
        System.out.println("Version: " + HidServices.getVersion());
    }

    public HidServices() throws HidException {
        this(new HidServicesSpecification());
    }

    public HidServices(HidServicesSpecification hidServicesSpecification) {
        this.hidDeviceManager = new HidDeviceManager(this.listeners, hidServicesSpecification);
        if (hidServicesSpecification.isAutoStart()) {
            this.hidDeviceManager.start();
        }
        if (hidServicesSpecification.isAutoShutdown()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    HidServices.this.shutdown();
                }
            });
        }
    }

    public void shutdown() {
        this.stop();
        try {
            HidApi.exit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop() {
        this.hidDeviceManager.stop();
        this.listeners.clear();
    }

    public void start() {
        this.hidDeviceManager.start();
    }

    public void addHidServicesListener(HidServicesListener listener) {
        this.listeners.add(listener);
    }

    public void removeHidServicesListener(HidServicesListener listener) {
        this.listeners.remove(listener);
    }

    public void scan() {
        this.hidDeviceManager.scan();
    }

    public List<HidDevice> getAttachedHidDevices() {
        return this.hidDeviceManager.getAttachedHidDevices();
    }

    public HidDevice getHidDevice(int vendorId, int productId, String serialNumber) {
        List<HidDevice> devices = this.hidDeviceManager.getAttachedHidDevices();
        for (HidDevice device : devices) {
            if (!device.isVidPidSerial(vendorId, productId, serialNumber)) continue;
            device.open();
            return device;
        }
        return null;
    }

    public static String getVersion() {
        Manifest manifest;
        Class<HidServices> clazz = HidServices.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return "0.0.1";
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            manifest = new Manifest(new URL(manifestPath).openStream());
        }
        catch (IOException e) {
            return "0.0.2";
        }
        Attributes attr = manifest.getMainAttributes();
        String value = attr.getValue("Implementation-Version");
        if (null == value) {
            return "0.0.3";
        }
        return value;
    }

    public static String getNativeVersion() {
        return HidApi.getVersion();
    }
}

