/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import com.mojang.authlib.GameProfile;
import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.global.PlayerTrainChunkManager;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class ChunkManagerEnrollmentHandler {
    private static final String UUID_TAG = "EnrollmentHandlerOwner";
    private UUID uuid = null;
    private int enrollMe = -1;
    private final Entity entity;

    public void tick() {
        if (this.enrollMe >= 0) {
            this.enrollMe = this.enrollMe == 0 && !PlayerTrainChunkManager.enroll(this.entity, this.uuid) ? 100 : --this.enrollMe;
        }
    }

    public boolean hasOwner() {
        return this.uuid != null;
    }

    public boolean mayMove() {
        if (this.uuid == null) {
            return true;
        }
        if (((Boolean)ShippingConfig.Server.OFFLINE_LOADING.get()).booleanValue()) {
            return true;
        }
        return PlayerTrainChunkManager.get((ServerLevel)this.entity.m_9236_(), this.uuid).isActive() && this.enrollMe < 0;
    }

    public void enroll(UUID uuid) {
        if (PlayerTrainChunkManager.enrollIfAllowed(this.entity, uuid)) {
            this.uuid = uuid;
        }
    }

    public void save(CompoundTag tag) {
        if (this.uuid != null) {
            tag.m_128362_(UUID_TAG, this.uuid);
        }
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_(UUID_TAG)) {
            this.uuid = tag.m_128342_(UUID_TAG);
            this.enrollMe = 5;
        }
    }

    public Optional<String> getPlayerName() {
        if (this.uuid == null) {
            return Optional.empty();
        }
        return ((ServerLevel)this.entity.m_9236_()).m_7654_().m_129927_().m_11002_(this.uuid).map(GameProfile::getName);
    }

    public ChunkManagerEnrollmentHandler(Entity entity) {
        this.entity = entity;
    }
}

