/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel.tug;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.accessor.SteamHeadVehicleDataAccessor;
import dev.murad.shipping.entity.container.SteamHeadVehicleContainer;
import dev.murad.shipping.entity.custom.vessel.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModSounds;
import dev.murad.shipping.util.FuelItemStackHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class SteamTugEntity
extends AbstractTugEntity {
    private final ForgeConfigSpec.ConfigValue<Double> FURNACE_FUEL_MULTIPLIER = ShippingConfig.Server.STEAM_TUG_FUEL_MULTIPLIER;
    private final FuelItemStackHandler fuelItemHandler = new FuelItemStackHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.fuelItemHandler);
    protected int burnTime = 0;
    protected int burnCapacity = 0;

    public SteamTugEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
    }

    public SteamTugEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntityTypes.STEAM_TUG.get(), worldIn, x, y, z);
    }

    @Override
    protected MenuProvider createContainerProvider() {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"screen.littlelogistics.tug");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player player) {
                return new SteamHeadVehicleContainer(i, SteamTugEntity.this.m_9236_(), SteamTugEntity.this.getDataAccessor(), playerInventory, player);
            }
        };
    }

    public int getBurnProgress() {
        int i = this.burnCapacity;
        if (i == 0) {
            i = 200;
        }
        return this.burnTime * 13 / i;
    }

    public boolean isLit() {
        return this.burnTime > 0;
    }

    @Override
    public SteamHeadVehicleDataAccessor getDataAccessor() {
        return (SteamHeadVehicleDataAccessor)new SteamHeadVehicleDataAccessor.Builder().withBurnProgress(this::getBurnProgress).withId(this.m_19879_()).withLit(this::isLit).withVisitedSize(() -> this.nextStop).withOn(() -> this.engineOn).withRouteSize(() -> this.path != null ? this.path.size() : 0).withCanMove(this.enrollmentHandler::mayMove).build();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected boolean tickFuel() {
        int adjustedBurnTime;
        if (this.burnTime > 0) {
            --this.burnTime;
            return true;
        }
        int burnTime = this.fuelItemHandler.tryConsumeFuel();
        this.burnCapacity = adjustedBurnTime = (int)Math.ceil((double)burnTime * (Double)this.FURNACE_FUEL_MULTIPLIER.get());
        this.burnTime = adjustedBurnTime;
        return adjustedBurnTime > 0;
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.STEAM_TUG.get();
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        this.burnTime = compound.m_128441_("burn") ? compound.m_128451_("burn") : 0;
        this.burnCapacity = compound.m_128441_("burn_capacity") ? compound.m_128451_("burn_capacity") : 0;
        this.fuelItemHandler.deserializeNBT(compound.m_128469_("fuelItems"));
        super.m_7378_(compound);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        compound.m_128405_("burn", this.burnTime);
        compound.m_128405_("burn_capacity", this.burnCapacity);
        compound.m_128365_("fuelItems", (Tag)this.fuelItemHandler.serializeNBT());
        super.m_7380_(compound);
    }

    @Override
    protected void onUndock() {
        super.onUndock();
        this.m_5496_((SoundEvent)ModSounds.STEAM_TUG_WHISTLE.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public boolean m_7983_() {
        return this.fuelItemHandler.getStackInSlot(0).m_41619_();
    }

    @NotNull
    public ItemStack m_8020_(int p_70301_1_) {
        return this.fuelItemHandler.getStackInSlot(p_70301_1_);
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        if (!this.fuelItemHandler.isItemValid(slot, stack)) {
            return;
        }
        this.fuelItemHandler.insertItem(slot, stack, false);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }
}

