/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.rail;

import java.util.Set;
import net.minecraft.core.Direction;

public class BranchingRailConfiguration {
    private final Direction rootDirection;
    private final Direction unpoweredDirection;
    private final Direction poweredDirection;
    static final Set<Direction> NO_POSSIBILITIES = Set.of();

    public Set<Direction> getPossibleDirections(Direction inputSide, boolean automaticSwitching, boolean powered) {
        if (inputSide == this.getRootDirection()) {
            if (automaticSwitching) {
                return Set.of(this.getUnpoweredDirection(), this.getPoweredDirection());
            }
            return powered ? Set.of(this.getPoweredDirection()) : Set.of(this.getUnpoweredDirection());
        }
        if (inputSide == this.getUnpoweredDirection()) {
            if (automaticSwitching) {
                return Set.of(this.getRootDirection());
            }
            return powered ? NO_POSSIBILITIES : Set.of(this.getRootDirection());
        }
        if (inputSide == this.getPoweredDirection()) {
            if (automaticSwitching) {
                return Set.of(this.getRootDirection());
            }
            return powered ? Set.of(this.getRootDirection()) : NO_POSSIBILITIES;
        }
        return NO_POSSIBILITIES;
    }

    public Direction getRootDirection() {
        return this.rootDirection;
    }

    public Direction getUnpoweredDirection() {
        return this.unpoweredDirection;
    }

    public Direction getPoweredDirection() {
        return this.poweredDirection;
    }

    public BranchingRailConfiguration(Direction rootDirection, Direction unpoweredDirection, Direction poweredDirection) {
        this.rootDirection = rootDirection;
        this.unpoweredDirection = unpoweredDirection;
        this.poweredDirection = poweredDirection;
    }
}

