/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.integrations.jei;

import com.mojang.blaze3d.platform.InputConstants;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import thetadev.constructionwand.basics.ConfigClient;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.items.ModItems;

@JeiPlugin
public class ConstructionWandJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = new ResourceLocation("constructionwand", "constructionwand");
    private static final String baseKey = "constructionwand.description.";
    private static final String baseKeyItem = "item.constructionwand.";

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    private Component keyComboComponent(boolean shiftOpt, Component optkeyComponent) {
        String key = shiftOpt ? "sneak_opt" : "sneak";
        return Component.m_237110_((String)("constructionwand.description.key." + key), (Object[])new Object[]{optkeyComponent}).m_130940_(ChatFormatting.BLUE);
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        MutableComponent optkeyComponent = Component.m_237115_((String)InputConstants.m_84827_((int)((Integer)ConfigClient.OPT_KEY.get()), (int)-1).m_84874_()).m_130940_(ChatFormatting.BLUE);
        Component wandModeComponent = this.keyComboComponent((Boolean)ConfigClient.SHIFTOPT_MODE.get(), (Component)optkeyComponent);
        Component wandGuiComponent = this.keyComboComponent((Boolean)ConfigClient.SHIFTOPT_GUI.get(), (Component)optkeyComponent);
        for (RegistryObject<Item> wandSupplier : ModItems.WANDS) {
            Item wand = (Item)wandSupplier.get();
            ConfigServer.WandProperties wandProperties = ConfigServer.getWandProperties(wand);
            String durabilityKey = wand == ModItems.WAND_INFINITY.get() ? "unlimited" : "limited";
            MutableComponent durabilityComponent = Component.m_237110_((String)("constructionwand.description.durability." + durabilityKey), (Object[])new Object[]{wandProperties.getDurability()});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)wand), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237110_((String)"constructionwand.description.wand", (Object[])new Object[]{Component.m_237115_((String)(baseKeyItem + ForgeRegistries.ITEMS.getKey((Object)wand).m_135815_())), wandProperties.getLimit(), durabilityComponent, optkeyComponent, wandModeComponent, wandGuiComponent})});
        }
        for (RegistryObject<Item> coreSupplier : ModItems.CORES) {
            Item core = (Item)coreSupplier.get();
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)core), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)(baseKey + ForgeRegistries.ITEMS.getKey((Object)core).m_135815_())).m_130946_("\n\n").m_7220_((Component)Component.m_237110_((String)"constructionwand.description.core", (Object[])new Object[]{wandModeComponent}))});
        }
    }
}

