/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.data;

import java.util.List;
import java.util.Set;
import mcjty.deepresonance.modules.tank.data.TankBlob;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.multiblock.IMultiblock;
import mcjty.lib.multiblock.IMultiblockFixer;
import mcjty.lib.multiblock.MultiblockDriver;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class TankFixer
implements IMultiblockFixer<TankBlob> {
    public void initialize(MultiblockDriver<TankBlob> driver, Level level, TankBlob newMb, int id) {
    }

    public void merge(MultiblockDriver<TankBlob> driver, Level level, TankBlob mbMain, TankBlob mbOther) {
        mbMain.merge(mbOther);
    }

    public void distribute(MultiblockDriver<TankBlob> driver, Level level, TankBlob original, List<Pair<Integer, Set<BlockPos>>> todo) {
        LiquidCrystalData data = original.getData();
        int totalAmount = data.getAmount();
        int totalBlocks = 0;
        for (Pair<Integer, Set<BlockPos>> pair : todo) {
            totalBlocks += ((Set)pair.getRight()).size();
        }
        if (totalBlocks == 0) {
            return;
        }
        int amountPerBlock = totalAmount / totalBlocks;
        int remainder = totalAmount % totalBlocks;
        for (Pair<Integer, Set<BlockPos>> pair : todo) {
            TankBlob builder = new TankBlob();
            int generatorBlocks = ((Set)pair.getRight()).size();
            data.setAmount(remainder + amountPerBlock * generatorBlocks);
            TankBlob mb = builder.setTankBlocks(generatorBlocks).copyData(data);
            mb.updateDistribution((Set)pair.getRight());
            driver.createOrUpdate(((Integer)pair.getKey()).intValue(), (IMultiblock)mb);
            remainder = 0;
        }
    }
}

