/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.core.init;

import cy.jdkdigital.dyenamics.common.blocks.DyenamicBannerBlock;
import cy.jdkdigital.dyenamics.common.blocks.DyenamicBedBlock;
import cy.jdkdigital.dyenamics.common.blocks.DyenamicCarpetBlock;
import cy.jdkdigital.dyenamics.common.blocks.DyenamicShulkerBoxBlock;
import cy.jdkdigital.dyenamics.common.blocks.DyenamicStainedGlassBlock;
import cy.jdkdigital.dyenamics.common.blocks.DyenamicStainedGlassPane;
import cy.jdkdigital.dyenamics.common.blocks.DyenamicWallBannerBlock;
import cy.jdkdigital.dyenamics.common.items.DyenamicBannerItem;
import cy.jdkdigital.dyenamics.common.items.DyenamicBedBlockItem;
import cy.jdkdigital.dyenamics.common.items.DyenamicShulkerBlockItem;
import cy.jdkdigital.dyenamics.core.init.ItemInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"dyenamics");
    public static final Map<String, Map<String, RegistryObject<Block>>> DYED_BLOCKS = new HashMap<String, Map<String, RegistryObject<Block>>>();

    public static void register() {
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            BlockInit.registerDyeBlocks(color);
        }
    }

    public static synchronized void registerDyeBlocks(DyenamicDyeColor color) {
        String colorName = color.m_7912_();
        int light = color.getLightValue();
        MapColor mapColor = color.getMapColor();
        DyeColor analogue = color.getAnalogue();
        HashMap<String, RegistryObject<Block>> blocks = new HashMap<String, RegistryObject<Block>>();
        DYED_BLOCKS.put(colorName, blocks);
        BlockInit.registerBlockAndItem(colorName, "terracotta", blocks, BlockItem::new, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50287_).m_284180_(mapColor).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "glazed_terracotta", blocks, BlockItem::new, () -> new GlazedTerracottaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50526_).m_284268_(analogue).m_60953_(state -> light)));
        RegistryObject<Block> concrete = BlockInit.registerBlockAndItem(colorName, "concrete", blocks, BlockItem::new, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50542_).m_284268_(analogue).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "concrete_powder", blocks, BlockItem::new, () -> new ConcretePowderBlock((Block)concrete.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50506_).m_284268_(analogue).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "wool", blocks, BlockItem::new, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284180_(mapColor).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "rockwool", blocks, BlockItem::new, () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "carpet", blocks, BlockItem::new, () -> new DyenamicCarpetBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50336_).m_284180_(mapColor).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "stained_glass", blocks, BlockItem::new, () -> new DyenamicStainedGlassBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50147_).m_284180_(mapColor).m_60953_(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "stained_glass_pane", blocks, BlockItem::new, () -> new DyenamicStainedGlassPane(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50303_).m_284180_(mapColor).m_60953_(state -> light)));
        RegistryObject<Block> candle = BlockInit.registerBlockAndItem(colorName, "candle", blocks, BlockItem::new, () -> new CandleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152482_).m_284180_(mapColor).m_60953_(state -> light > 0 ? light : CandleBlock.f_152793_.applyAsInt(state))));
        BlockInit.registerBlockAndItem(colorName, "candle_cake", blocks, null, () -> new CandleCakeBlock((Block)candle.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152525_).m_60953_(state -> light > 0 ? light : ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 3 : 0))));
        BlockInit.registerBedAndItem(colorName, "bed", blocks, DyenamicBedBlockItem::new, () -> new DyenamicBedBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50066_).m_284495_(state -> state.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT ? mapColor : MapColor.f_283930_).m_60953_(state -> light)));
        BlockInit.registerShulkerBoxAndItem(colorName, "shulker_box", blocks, DyenamicShulkerBlockItem::new, () -> new DyenamicShulkerBoxBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50456_).m_284180_(mapColor)));
        RegistryObject<Block> wallBanner = BlockInit.registerBlockAndItem(colorName, "wall_banner", blocks, null, () -> new DyenamicWallBannerBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50414_).m_60953_(state -> light)));
        BlockInit.registerBannerBlockAndItem(colorName, "banner", blocks, () -> new DyenamicBannerBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50414_).m_60953_(state -> light)), wallBanner);
    }

    public static synchronized RegistryObject<Block> registerBedAndItem(String color, String nameSuffix, Map<String, RegistryObject<Block>> blockMap, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier) {
        return BlockInit.registerBlockAndItem(color, nameSuffix, blockMap, itemSupplier, supplier, new Item.Properties().m_41487_(1));
    }

    public static synchronized RegistryObject<Block> registerShulkerBoxAndItem(String color, String nameSuffix, Map<String, RegistryObject<Block>> blockMap, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier) {
        return BlockInit.registerBlockAndItem(color, nameSuffix, blockMap, itemSupplier, supplier, new Item.Properties().m_41487_(1));
    }

    public static synchronized RegistryObject<Block> registerBlockAndItem(String color, String nameSuffix, Map<String, RegistryObject<Block>> blockMap, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier) {
        return BlockInit.registerBlockAndItem(color, nameSuffix, blockMap, itemSupplier, supplier, new Item.Properties());
    }

    public static synchronized RegistryObject<Block> registerBlockAndItem(String color, String nameSuffix, Map<String, RegistryObject<Block>> blockMap, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier, Item.Properties itemProperties) {
        String name = color + "_" + nameSuffix;
        RegistryObject block = BLOCKS.register(name, supplier);
        if (itemSupplier != null) {
            ItemInit.ITEMS.register(name, () -> itemSupplier.create((Block)block.get(), itemProperties));
        }
        blockMap.put(nameSuffix, (RegistryObject<Block>)block);
        return block;
    }

    public static synchronized RegistryObject<Block> registerBannerBlockAndItem(String color, String nameSuffix, Map<String, RegistryObject<Block>> blockMap, Supplier<Block> banner, RegistryObject<Block> wallBanner) {
        String name = color + "_" + nameSuffix;
        RegistryObject block = BLOCKS.register(name, banner);
        ItemInit.ITEMS.register(name, () -> new DyenamicBannerItem((Block)block.get(), (Block)wallBanner.get(), new Item.Properties().m_41487_(16)));
        blockMap.put(nameSuffix, (RegistryObject<Block>)block);
        return block;
    }

    @FunctionalInterface
    public static interface BlockItemSupplier<T extends BlockItem> {
        public T create(Block var1, Item.Properties var2);
    }
}

