/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.CountedItemStacks;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.Validate;

public abstract class CompiledModule {
    private final Filter filter;
    private final ModuleItem module;
    private final ModuleItem.RelativeDirection direction;
    private final List<ModuleTarget> targets;
    private final RouterRedstoneBehaviour behaviour;
    private final ModuleItem.Termination termination;
    private final Direction facing;
    private final Direction routerFacing;
    private final int regulationAmount;
    private final AugmentItem.AugmentCounter augmentCounter;
    private final int range;
    private final int rangeSquared;
    private int lastMatchPos = 0;
    private final Map<BlockPos, Integer> lastMatchPosMap = new Object2IntOpenHashMap();

    CompiledModule(@Nullable ModularRouterBlockEntity router, ItemStack stack) {
        Validate.isTrue((boolean)(stack.m_41720_() instanceof ModuleItem), (String)("expected module item, got " + stack), (Object[])new Object[0]);
        this.module = (ModuleItem)stack.m_41720_();
        this.augmentCounter = new AugmentItem.AugmentCounter(stack);
        this.direction = ModuleHelper.getRelativeDirection(stack);
        this.range = this.module instanceof IRangedModule ? ((IRangedModule)((Object)this.module)).getCurrentRange(this.getRangeModifier()) : 0;
        this.rangeSquared = this.range * this.range;
        this.targets = this.setupTargets(router, stack);
        this.filter = new Filter(stack, this.shouldStoreRawFilterItems(), this.augmentCounter.getAugmentCount((Item)ModItems.FILTER_ROUND_ROBIN_AUGMENT.get()) > 0);
        this.termination = ModuleHelper.getTermination(stack);
        this.behaviour = ModuleHelper.getRedstoneBehaviour(stack);
        this.regulationAmount = ModuleHelper.getRegulatorAmount(stack);
        this.facing = router == null ? null : router.getAbsoluteFacing(this.direction);
        this.routerFacing = router == null ? null : router.getAbsoluteFacing(ModuleItem.RelativeDirection.FRONT);
    }

    public abstract boolean execute(@Nonnull ModularRouterBlockEntity var1);

    @Nonnull
    public Filter getFilter() {
        return this.filter;
    }

    public ModuleItem.RelativeDirection getDirection() {
        return this.direction;
    }

    protected boolean shouldStoreRawFilterItems() {
        return false;
    }

    ModuleTarget getTarget() {
        return this.targets == null || this.targets.isEmpty() ? null : this.targets.get(0);
    }

    List<ModuleTarget> getTargets() {
        return this.targets;
    }

    public boolean hasTarget() {
        return this.targets != null && !this.targets.isEmpty();
    }

    public ModuleItem.Termination termination() {
        return this.termination;
    }

    RouterRedstoneBehaviour getRedstoneBehaviour() {
        return this.behaviour;
    }

    public int getRegulationAmount() {
        return this.augmentCounter.getAugmentCount((Item)ModItems.REGULATOR_AUGMENT.get()) > 0 ? this.regulationAmount : 0;
    }

    int getAugmentCount(Item augmentType) {
        return this.augmentCounter.getAugmentCount(augmentType);
    }

    Direction getFacing() {
        return this.facing;
    }

    public void onCompiled(ModularRouterBlockEntity router) {
        if (this.behaviour == RouterRedstoneBehaviour.PULSE) {
            router.setHasPulsedModules(true);
        }
    }

    public void cleanup(ModularRouterBlockEntity router) {
    }

    private int getLastMatchPos(BlockPos key, int offset, int size) {
        int pos;
        for (pos = (key == null ? this.lastMatchPos : this.lastMatchPosMap.getOrDefault(key, 0)) + offset; pos >= size; pos -= size) {
        }
        return pos;
    }

    private void setLastMatchPos(BlockPos key, int lastMatchPos) {
        if (key == null) {
            this.lastMatchPos = lastMatchPos;
        } else {
            this.lastMatchPosMap.put(key, lastMatchPos);
        }
    }

    List<ModuleTarget> setupTargets(ModularRouterBlockEntity router, ItemStack stack) {
        if (router == null || this.module.isDirectional() && this.direction == ModuleItem.RelativeDirection.NONE) {
            return null;
        }
        Direction facing = router.getAbsoluteFacing(this.direction);
        BlockPos pos = router.m_58899_().m_121945_(facing);
        String blockName = BlockUtil.getBlockName(router.m_58904_(), pos);
        GlobalPos gPos = MiscUtil.makeGlobalPos(router.nonNullLevel(), pos);
        return Collections.singletonList(new ModuleTarget(gPos, facing.m_122424_(), blockName));
    }

    int getItemsPerTick(ModularRouterBlockEntity router) {
        int n = this.augmentCounter.getAugmentCount((Item)ModItems.STACK_AUGMENT.get());
        return n > 0 ? Math.min(1 << n, 64) : router.getItemsPerTick();
    }

    ItemStack transferToRouter(IItemHandler handler, @Nullable BlockPos key, ModularRouterBlockEntity router) {
        CountedItemStacks count = this.getRegulationAmount() > 0 ? new CountedItemStacks(handler) : null;
        ItemStack wanted = this.findItemToPull(router, handler, key, this.getItemsPerTick(router), count);
        if (wanted.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack transferred = ItemStack.f_41583_;
        for (int i = 0; i < handler.getSlots(); ++i) {
            int pos = this.getLastMatchPos(key, i, handler.getSlots());
            ItemStack toPull = handler.extractItem(pos, wanted.m_41613_(), true);
            if (toPull.m_41619_()) {
                this.setLastMatchPos(key, (pos + 1) % handler.getSlots());
                return transferred;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)wanted, (ItemStack)toPull)) continue;
            ItemStack notInserted = router.insertBuffer(toPull);
            int inserted = toPull.m_41613_() - notInserted.m_41613_();
            transferred = handler.extractItem(pos, inserted, false);
            wanted.m_41774_(inserted);
            if (!wanted.m_41619_() && !router.isBufferFull()) continue;
            this.setLastMatchPos(key, handler.getStackInSlot(pos).m_41619_() ? (pos + 1) % handler.getSlots() : pos);
            return transferred;
        }
        return transferred;
    }

    private ItemStack findItemToPull(ModularRouterBlockEntity router, IItemHandler handler, BlockPos key, int nToTake, CountedItemStacks count) {
        ItemStack stackInRouter = router.peekBuffer(1);
        if (!stackInRouter.m_41619_() && this.getFilter().test(stackInRouter) && (count == null || count.getInt(stackInRouter) - nToTake >= this.getRegulationAmount())) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stackInRouter, (int)nToTake);
        }
        if (stackInRouter.m_41619_()) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                int pos = this.getLastMatchPos(key, i, handler.getSlots());
                ItemStack stack = handler.getStackInSlot(pos);
                if (!this.getFilter().test(stack) || count != null && count.getInt(stack) - nToTake < this.getRegulationAmount()) continue;
                this.setLastMatchPos(key, pos);
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)nToTake);
            }
        }
        return ItemStack.f_41583_;
    }

    public ModuleTarget getEffectiveTarget(ModularRouterBlockEntity router) {
        return this.getTarget();
    }

    public boolean shouldRun(boolean powered, boolean pulsed) {
        return this.getRedstoneBehaviour().shouldRun(powered, pulsed);
    }

    boolean isRegulationOK(ModularRouterBlockEntity router, boolean inbound) {
        if (this.regulationAmount == 0) {
            return true;
        }
        int items = router.getBufferItemStack().m_41613_();
        return inbound && this.regulationAmount > items || !inbound && this.regulationAmount < items;
    }

    int getRange() {
        return this.range;
    }

    int getRangeSquared() {
        return this.rangeSquared;
    }

    private int getRangeModifier() {
        return this.getAugmentCount((Item)ModItems.RANGE_UP_AUGMENT.get()) - this.getAugmentCount((Item)ModItems.RANGE_DOWN_AUGMENT.get());
    }

    Direction getRouterFacing() {
        return this.routerFacing;
    }

    public void onNeighbourChange(ModularRouterBlockEntity router) {
    }

    public int getEnergyCost() {
        return this.module.getEnergyCost(ItemStack.f_41583_);
    }

    public boolean careAboutItemAttributes() {
        return false;
    }
}

