/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import me.desht.modularrouters.client.gui.filter.AbstractFilterContainerScreen;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.item.smartfilter.TagFilter;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class TagFilterScreen
extends AbstractFilterContainerScreen {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("modularrouters", "textures/gui/tagfilter.png");
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 252;
    private final List<TagKey<Item>> addedTags = Lists.newArrayList();
    private final List<Buttons.DeleteButton> deleteButtons = Lists.newArrayList();
    private ItemStack prevInSlot = ItemStack.f_41583_;
    private final List<TagKey<Item>> candidateTags = new ArrayList<TagKey<Item>>();
    private TagKey<Item> selectedTag = null;
    private boolean tagSelectorShowing = false;
    private ExtendedButton selectButton;
    private final List<ExtendedButton> optionButtons = new ArrayList<ExtendedButton>();

    public TagFilterScreen(AbstractSmartFilterMenu container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
        this.f_97726_ = 256;
        this.f_97727_ = 252;
        this.addedTags.addAll(TagFilter.getTagList(this.filterStack));
    }

    public void m_7856_() {
        super.m_7856_();
        if (((AbstractSmartFilterMenu)this.f_97732_).getLocator().filterSlot >= 0) {
            this.m_142416_((GuiEventListener)new BackButton(this.f_97735_ - 12, this.f_97736_, p -> this.closeGUI()));
        }
        this.m_142416_((GuiEventListener)new Buttons.AddButton(this.f_97735_ + 234, this.f_97736_ + 19, p -> {
            if (this.selectedTag != null) {
                CompoundTag ext = new CompoundTag();
                ext.m_128359_("Tag", this.selectedTag.f_203868_().toString());
                PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.ADD_STRING, ((AbstractSmartFilterMenu)this.f_97732_).getLocator(), ext));
            }
        }));
        this.deleteButtons.clear();
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.f_97735_ + 8, this.f_97736_ + 44 + i * 19, i, button -> {
                CompoundTag ext = new CompoundTag();
                ext.m_128405_("Pos", ((Buttons.DeleteButton)button).getId());
                PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.REMOVE_AT, ((AbstractSmartFilterMenu)this.f_97732_).getLocator(), ext));
            });
            this.m_142416_((GuiEventListener)b);
            this.deleteButtons.add(b);
        }
        this.selectButton = new ExtendedButton(this.f_97735_ + 218, this.f_97736_ + 20, 14, 14, (Component)Component.m_237113_((String)"\u25bc"), p -> {
            this.tagSelectorShowing = !this.tagSelectorShowing;
            this.updateButtonVisibility();
        });
        this.m_142416_((GuiEventListener)this.selectButton);
        this.selectButton.f_93624_ = false;
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).f_93624_ = i < this.addedTags.size() && !this.tagSelectorShowing;
        }
        this.optionButtons.forEach(b -> {
            b.f_93624_ = this.tagSelectorShowing;
        });
        this.selectButton.m_93666_((Component)Component.m_237113_((String)(this.tagSelectorShowing ? "\u25b2" : "\u25bc")));
        this.selectButton.f_93624_ = this.candidateTags.size() > 1;
    }

    private void rebuildOptionButtons() {
        this.optionButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.optionButtons.clear();
        if (this.candidateTags.size() > 1) {
            for (int i = 0; i < this.candidateTags.size(); ++i) {
                Objects.requireNonNull(this.f_96547_);
                SelectorButton sb = new SelectorButton(this.f_97735_ + 8, this.f_97736_ + 44 + i * (9 + 5), this.candidateTags.get(i));
                this.optionButtons.add(sb);
                this.m_142416_((GuiEventListener)sb);
            }
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        String title = this.filterStack.m_41786_().getString() + (((AbstractSmartFilterMenu)this.f_97732_).getRouter() != null ? I18n.m_118938_((String)"modularrouters.guiText.label.installed", (Object[])new Object[0]) : "");
        graphics.m_280056_(this.f_96547_, title, this.f_97726_ / 2 - this.f_96547_.m_92895_(title) / 2, 8, 0x404040, false);
        if (this.selectedTag != null) {
            int maxW = this.selectButton.f_93624_ ? 190 : 205;
            graphics.m_280649_(this.f_96547_, ClientUtil.ellipsize(this.f_96547_, this.selectedTag.f_203868_().toString(), maxW), 29, 23, 0x404040, false);
        } else if (this.candidateTags.size() > 1) {
            graphics.m_280614_(this.f_96547_, (Component)ClientUtil.xlate("modularrouters.guiText.label.selectTag", new Object[0]).m_130940_(ChatFormatting.ITALIC), 29, 23, 0x808080, false);
        } else if (this.candidateTags.isEmpty()) {
            graphics.m_280614_(this.f_96547_, (Component)ClientUtil.xlate("modularrouters.guiText.label.noTags", new Object[0]).m_130940_(ChatFormatting.ITALIC), 29, 23, 0x808080, false);
        }
        if (!this.tagSelectorShowing) {
            for (int i = 0; i < this.addedTags.size(); ++i) {
                String tag = this.addedTags.get(i).f_203868_().toString();
                graphics.m_280649_(this.f_96547_, ClientUtil.ellipsize(this.f_96547_, tag, 220), 28, 47 + i * 19, 0x404080, false);
            }
        }
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        ItemStack inSlot = (ItemStack)((AbstractSmartFilterMenu)this.m_6262_()).m_38927_().get(0);
        if (inSlot.m_41619_() && !this.prevInSlot.m_41619_()) {
            this.candidateTags.clear();
            this.selectedTag = null;
            this.tagSelectorShowing = false;
            this.rebuildOptionButtons();
            this.updateButtonVisibility();
        } else if (!(inSlot.m_41619_() || !this.prevInSlot.m_41619_() && MiscUtil.sameItemStackIgnoreDurability(inSlot, this.prevInSlot))) {
            List<TagKey> l = MiscUtil.itemTags(inSlot.m_41720_()).stream().sorted(Comparator.comparing(TagKey::f_203868_)).toList();
            this.candidateTags.clear();
            this.candidateTags.addAll(l);
            this.selectedTag = this.candidateTags.size() == 1 ? l.get(0) : null;
            this.rebuildOptionButtons();
            this.updateButtonVisibility();
        }
        this.prevInSlot = inSlot;
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE_LOCATION, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    public void resync(ItemStack filterStack) {
        this.addedTags.clear();
        this.addedTags.addAll(TagFilter.getTagList(filterStack));
        this.tagSelectorShowing = false;
        this.updateButtonVisibility();
    }

    private class SelectorButton
    extends ExtendedButton {
        public SelectorButton(int xPos, int yPos, TagKey<Item> tag) {
            Objects.requireNonNull(TagFilterScreen.this.f_96547_);
            super(xPos, yPos, 239, 9 + 5, (Component)Component.m_237113_((String)tag.f_203868_().toString()), p -> {
                me$desht$modularrouters$client$gui$filter$TagFilterScreen$this.selectedTag = tag;
                me$desht$modularrouters$client$gui$filter$TagFilterScreen$this.tagSelectorShowing = false;
                TagFilterScreen.this.updateButtonVisibility();
            });
        }
    }
}

