/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.data.JsonLoader;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.NetworkLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ContentBookEntry
extends BookEntry {
    protected List<BookPage> pages;

    public ContentBookEntry(ResourceLocation id, BookEntry.BookEntryData data, ResourceLocation commandToRunOnFirstReadId, List<BookPage> pages) {
        super(id, data, commandToRunOnFirstReadId);
        this.pages = pages;
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.EntryType.CONTENT;
    }

    public static ContentBookEntry fromJson(ResourceLocation id, JsonObject json, boolean autoAddReadConditions) {
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromJson(json, autoAddReadConditions);
        ResourceLocation commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            commandToRunOnFirstReadId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"command_to_run_on_first_read"));
        }
        ArrayList<BookPage> pages = new ArrayList<BookPage>();
        if (json.has("pages")) {
            JsonArray jsonPages = GsonHelper.m_13933_((JsonObject)json, (String)"pages");
            for (JsonElement pageElem : jsonPages) {
                BookErrorManager.get().setContext("Page Index: {}", pages.size());
                JsonObject pageJson = GsonHelper.m_13918_((JsonElement)pageElem, (String)"page");
                ResourceLocation type = new ResourceLocation(GsonHelper.m_13906_((JsonObject)pageJson, (String)"type"));
                JsonLoader<? extends BookPage> loader = LoaderRegistry.getPageJsonLoader(type);
                BookPage page = loader.fromJson(pageJson);
                pages.add(page);
            }
        }
        return new ContentBookEntry(id, data, commandToRunOnFirstReadId, pages);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        this.data.toNetwork(buffer);
        buffer.m_236821_((Object)this.commandToRunOnFirstReadId, FriendlyByteBuf::m_130085_);
        buffer.m_130130_(this.pages.size());
        for (BookPage page : this.pages) {
            buffer.m_130085_(page.getType());
            page.toNetwork(buffer);
        }
    }

    public static ContentBookEntry fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromNetwork(buffer);
        ResourceLocation commandToRunOnFirstReadId = (ResourceLocation)buffer.m_236868_(FriendlyByteBuf::m_130281_);
        ArrayList<BookPage> pages = new ArrayList<BookPage>();
        int pageCount = buffer.m_130242_();
        for (int i = 0; i < pageCount; ++i) {
            ResourceLocation type = buffer.m_130281_();
            NetworkLoader<? extends BookPage> loader = LoaderRegistry.getPageNetworkLoader(type);
            BookPage page = loader.fromNetwork(buffer);
            pages.add(page);
        }
        return new ContentBookEntry(id, data, commandToRunOnFirstReadId, pages);
    }

    @Override
    public void build(Level level, BookCategory category) {
        super.build(level, category);
        int pageNum = 0;
        for (BookPage page : this.pages) {
            BookErrorManager.get().getContextHelper().pageNumber = pageNum;
            page.build(level, this, pageNum);
            BookErrorManager.get().getContextHelper().pageNumber = -1;
            ++pageNum;
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        for (BookPage page : this.pages) {
            BookErrorManager.get().getContextHelper().pageNumber = page.getPageNumber();
            page.prerenderMarkdown(textRenderer);
            BookErrorManager.get().getContextHelper().pageNumber = -1;
        }
    }

    @Override
    public List<BookPage> getPages() {
        return this.pages;
    }

    @Override
    public List<BookPage> getUnlockedPagesFor(Player player) {
        BookUnlockStateManager unlockManager = BookUnlockStateManager.get();
        return unlockManager.getUnlockedPagesFor(player, this);
    }

    @Override
    public int getPageNumberForAnchor(String anchor) {
        List<BookPage> pages = this.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            BookPage page = pages.get(i);
            if (!anchor.equals(page.getAnchor())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean matchesQuery(String query) {
        if (super.matchesQuery(query)) {
            return true;
        }
        for (BookPage page : this.getPages()) {
            if (!page.matchesQuery(query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BookContentScreen openEntry(BookCategoryScreen categoryScreen) {
        return categoryScreen.openContentEntry(this);
    }
}

