/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientUpdateActiveStorageIngredientPacket<T>
extends PacketCodec {
    @CodecField
    private String tabId;
    @CodecField
    private String ingredientName;
    @CodecField
    private int channel;
    @CodecField
    private CompoundTag activeStorageInstanceData;

    public TerminalStorageIngredientUpdateActiveStorageIngredientPacket() {
    }

    public TerminalStorageIngredientUpdateActiveStorageIngredientPacket(String tabId, IngredientComponent<T, ?> component, int channel, T activeStorageInstance) {
        this.tabId = tabId;
        this.ingredientName = component.getName().toString();
        this.channel = channel;
        IIngredientSerializer serializer = this.getComponent().getSerializer();
        this.activeStorageInstanceData = new CompoundTag();
        this.activeStorageInstanceData.m_128365_("i", serializer.serializeInstance(activeStorageInstance));
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        if (player.f_36096_ instanceof ContainerTerminalStorageBase) {
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.f_36096_;
            TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
            IIngredientSerializer serializer = this.getComponent().getSerializer();
            Object activeInstance = serializer.deserializeInstance(this.activeStorageInstanceData.m_128423_("i"));
            tab.handleActiveIngredientUpdate(this.getChannel(), activeInstance);
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }

    public IngredientComponent<T, ?> getComponent() {
        IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(this.ingredientName));
        if (ingredientComponent == null) {
            throw new IllegalArgumentException("No ingredient component with the given name was found: " + this.ingredientName);
        }
        return ingredientComponent;
    }

    public int getChannel() {
        return this.channel;
    }
}

