/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.helper.InventoryHelper;

public class RunicAltarBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape BOTTOM = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)TOP, (VoxelShape)BOTTOM, (BooleanOp)BooleanOp.f_82695_);

    public RunicAltarBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof RunicAltarBlockEntity)) {
            return InteractionResult.PASS;
        }
        RunicAltarBlockEntity altar = (RunicAltarBlockEntity)blockEntity;
        ItemStack stack = player.m_21120_(hand);
        boolean mainHandEmpty = player.m_21205_().m_41619_();
        if (altar.canAddLastRecipe() && mainHandEmpty) {
            return altar.trySetLastRecipe(player);
        }
        if (!altar.isEmpty() && altar.manaToGet == 0 && mainHandEmpty) {
            InventoryHelper.withdrawFromInventory(altar, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (!stack.m_41619_()) {
            boolean result = altar.addItem(player, stack, hand);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
            if (result) {
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new RunicAltarBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return RunicAltarBlock.createTickerHelper(type, BotaniaBlockEntities.RUNE_ALTAR, RunicAltarBlockEntity::clientTick);
        }
        return RunicAltarBlock.createTickerHelper(type, BotaniaBlockEntities.RUNE_ALTAR, RunicAltarBlockEntity::serverTick);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        RunicAltarBlockEntity altar = (RunicAltarBlockEntity)world.m_7702_(pos);
        return altar.signal;
    }
}

