/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block.entity;

import cy.jdkdigital.everythingcopper.common.block.WeatheringStation;
import cy.jdkdigital.everythingcopper.common.container.ManualItemHandler;
import cy.jdkdigital.everythingcopper.common.item.ICopperItem;
import cy.jdkdigital.everythingcopper.init.ModBlockEntities;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class WeatheringStationBlockEntity
extends BlockEntity
implements Nameable {
    public static int SLOT_INPUT = 0;
    public static int SLOT_FUEL = 1;
    public static int SLOT_OUTPUT = 2;
    private int tickCounter = 0;
    public boolean isRunning = false;
    public int fluidId = 0;
    public int progress = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new ManualItemHandler(3){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            BlockItem blockItem;
            Item item;
            if (slot == SLOT_FUEL) {
                if (stack.m_150930_(Items.f_42447_)) {
                    return true;
                }
                Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
                if (fluid.isPresent()) {
                    return ((FluidStack)fluid.get()).getFluid().m_6212_((Fluid)Fluids.f_76193_);
                }
            }
            return slot == SLOT_INPUT && (stack.m_41720_() instanceof ICopperItem && ICopperItem.canAge(stack) || (item = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof WeatheringCopper);
        }

        protected void onContentsChanged(int slot) {
            WeatheringStationBlockEntity.this.m_6596_();
            if (slot == SLOT_INPUT && this.getStackInSlot(slot).m_41619_()) {
                WeatheringStationBlockEntity.this.isRunning = false;
                WeatheringStationBlockEntity.this.progress = 0;
            }
        }
    });
    private final LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> new FluidTank(10000){

        public boolean isFluidValid(FluidStack stack) {
            return super.isFluidValid(stack);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            WeatheringStationBlockEntity.this.fluidId = BuiltInRegistries.f_257020_.m_7447_((Object)this.getFluid().getFluid());
            if (WeatheringStationBlockEntity.this.f_58857_ instanceof ServerLevel) {
                if (this.getFluidAmount() >= 100 && !((Boolean)WeatheringStationBlockEntity.this.m_58900_().m_61143_((Property)WeatheringStation.WET)).booleanValue()) {
                    WeatheringStationBlockEntity.this.f_58857_.m_46597_(WeatheringStationBlockEntity.this.m_58899_(), (BlockState)WeatheringStationBlockEntity.this.m_58900_().m_61124_((Property)WeatheringStation.WET, (Comparable)Boolean.valueOf(true)));
                } else if (this.getFluidAmount() < 100 && ((Boolean)WeatheringStationBlockEntity.this.m_58900_().m_61143_((Property)WeatheringStation.WET)).booleanValue()) {
                    WeatheringStationBlockEntity.this.f_58857_.m_46597_(WeatheringStationBlockEntity.this.m_58899_(), (BlockState)WeatheringStationBlockEntity.this.m_58900_().m_61124_((Property)WeatheringStation.WET, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    });

    public WeatheringStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.WEATHERING_STATION.get(), blockPos, blockState);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, WeatheringStationBlockEntity blockEntity) {
        ++blockEntity.tickCounter;
        blockEntity.inventoryHandler.ifPresent(items -> {
            if (blockEntity.tickCounter % 5 == 0) {
                blockEntity.fluidInventory.ifPresent(fluid -> {
                    int availableFluidSpace = fluid.getTankCapacity(0) - fluid.getFluidInTank(0).getAmount();
                    ItemStack fuelStack = items.getStackInSlot(SLOT_FUEL);
                    if (!fuelStack.m_41619_()) {
                        if (fuelStack.m_150930_(Items.f_42447_) && availableFluidSpace >= 1000) {
                            items.setStackInSlot(SLOT_FUEL, fuelStack.getCraftingRemainingItem());
                            fluid.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                        } else {
                            LazyOptional fuelContainer = FluidUtil.getFluidHandler((ItemStack)fuelStack);
                            fuelContainer.ifPresent(iFluidHandlerItem -> {
                                Optional fuel = fuelContainer.map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
                                if (fuel.isPresent() && ((FluidStack)fuel.get()).getAmount() > 0 && ((FluidStack)fuel.get()).getFluid().m_6212_((Fluid)Fluids.f_76193_)) {
                                    int transferAmount = Math.min(((FluidStack)fuel.get()).getAmount(), availableFluidSpace);
                                    FluidUtil.tryFluidTransfer((IFluidHandler)fluid, (IFluidHandler)iFluidHandlerItem, (int)transferAmount, (boolean)true);
                                }
                            });
                        }
                    }
                });
            }
            if (blockEntity.isRunning) {
                ++blockEntity.progress;
            }
            if (blockEntity.isRunning && blockEntity.progress >= 200) {
                BlockItem blockItem;
                Block patt7151$temp;
                AtomicBoolean hasFinished = new AtomicBoolean(false);
                ItemStack inputItem = items.getStackInSlot(SLOT_INPUT);
                ItemStack outputItem = items.getStackInSlot(SLOT_OUTPUT);
                Item patt7096$temp = inputItem.m_41720_();
                if (patt7096$temp instanceof BlockItem && (patt7151$temp = (blockItem = (BlockItem)patt7096$temp).m_40614_()) instanceof WeatheringCopper) {
                    WeatheringCopper weatheringBlock = (WeatheringCopper)patt7151$temp;
                    weatheringBlock.m_142123_(blockItem.m_40614_().m_49966_()).ifPresent(newState -> {
                        ItemStack newItem = new ItemStack((ItemLike)newState.m_60734_().m_5456_());
                        if (outputItem.m_41619_()) {
                            items.setStackInSlot(SLOT_OUTPUT, newItem);
                            hasFinished.set(true);
                        } else if (ItemStack.m_150942_((ItemStack)newItem, (ItemStack)outputItem) && outputItem.m_41613_() < outputItem.m_41741_()) {
                            outputItem.m_41769_(1);
                            hasFinished.set(true);
                        }
                    });
                } else if (outputItem.m_41619_() && inputItem.m_41720_() instanceof ICopperItem && ICopperItem.canAge(inputItem)) {
                    ItemStack newItem = inputItem.m_41777_();
                    ICopperItem.setAge(newItem, WeatheringUtils.nextState(ICopperItem.getAge(newItem)));
                    items.setStackInSlot(SLOT_OUTPUT, newItem);
                    hasFinished.set(true);
                }
                if (hasFinished.get()) {
                    inputItem.m_41774_(1);
                    blockEntity.isRunning = false;
                    blockEntity.progress = 0;
                }
            }
            if (!blockEntity.isRunning) {
                blockEntity.fluidInventory.ifPresent(fluid -> {
                    ItemStack inputItem = items.getStackInSlot(SLOT_INPUT);
                    if (!inputItem.m_41619_() && fluid.getFluidInTank(0).getAmount() >= 100) {
                        fluid.drain(100, IFluidHandler.FluidAction.EXECUTE);
                        blockEntity.isRunning = true;
                        blockEntity.progress = 0;
                    }
                });
            }
        });
    }

    @NotNull
    public Component m_5446_() {
        return this.m_7755_();
    }

    @NotNull
    public Component m_7755_() {
        return Component.m_237115_((String)"block.everythingcopper.weathering_station");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadPacketNBT(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.savePacketNBT(tag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.loadPacketNBT(pkt.m_131708_());
        if (this.f_58857_ instanceof ClientLevel) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
        }
    }

    public void savePacketNBT(CompoundTag tag) {
        this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            CompoundTag compound = ((ItemStackHandler)inv).serializeNBT();
            tag.m_128365_("inv", (Tag)compound);
        });
        this.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluid -> {
            CompoundTag nbt = new CompoundTag();
            ((FluidTank)fluid).writeToNBT(nbt);
            tag.m_128365_("fluid", (Tag)nbt);
        });
        tag.m_128405_("progress", this.progress);
    }

    public void loadPacketNBT(CompoundTag tag) {
        if (tag.m_128441_("inv")) {
            this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> ((ItemStackHandler)inv).deserializeNBT(tag.m_128469_("inv")));
        }
        if (tag.m_128441_("fluid")) {
            this.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluid -> ((FluidTank)fluid).readFromNBT(tag.m_128469_("fluid")));
        }
        this.progress = tag.m_128451_("progress");
    }
}

