/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import reliquary.common.gui.MobCharmBeltMenu;
import reliquary.item.ItemBase;
import reliquary.item.MobCharmItem;
import reliquary.item.util.ICuriosItem;
import reliquary.reference.Settings;

public class MobCharmBeltItem
extends ItemBase
implements ICuriosItem {
    private static final String SLOTS_TAG = "Slots";

    public MobCharmBeltItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public ICuriosItem.Type getCuriosType() {
        return ICuriosItem.Type.BELT;
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
    }

    @Override
    public void onEquipped(String identifier, LivingEntity player) {
        if (player.m_9236_().f_46443_) {
            player.m_5496_(SoundEvents.f_11678_, 1.0f, 1.0f);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new MobCharmBeltMenu(w, p, stack), stack.m_41786_()), buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public ItemStack getMobCharmInSlot(ItemStack belt, int slotIndex) {
        CompoundTag nbt = belt.m_41783_();
        if (nbt == null || !nbt.m_128441_(SLOTS_TAG)) {
            return ItemStack.f_41583_;
        }
        ListTag mobCharms = nbt.m_128437_(SLOTS_TAG, 10);
        if (mobCharms.size() <= slotIndex) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)((CompoundTag)mobCharms.get(slotIndex)));
    }

    public void putMobCharmInSlot(ItemStack belt, int slotIndex, ItemStack mobCharm) {
        ListTag mobCharms;
        if (mobCharm.m_41619_()) {
            this.removeMobCharmInSlot(belt, slotIndex);
            return;
        }
        CompoundTag mobCharmNbt = mobCharm.m_41739_(new CompoundTag());
        CompoundTag nbt = belt.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
            mobCharms = new ListTag();
        } else {
            mobCharms = nbt.m_128437_(SLOTS_TAG, 10);
        }
        if (mobCharms.size() < slotIndex) {
            return;
        }
        if (mobCharms.size() == slotIndex) {
            mobCharms.add((Object)mobCharmNbt);
        } else {
            mobCharms.set(slotIndex, (Tag)mobCharmNbt);
        }
        nbt.m_128365_(SLOTS_TAG, (Tag)mobCharms);
        belt.m_41751_(nbt);
    }

    public void removeMobCharmInSlot(ItemStack belt, int slotIndex) {
        CompoundTag nbt = belt.m_41783_();
        if (nbt == null || !nbt.m_128441_(SLOTS_TAG)) {
            return;
        }
        ListTag mobCharms = nbt.m_128437_(SLOTS_TAG, 10);
        if (mobCharms.size() <= slotIndex) {
            return;
        }
        mobCharms.remove(slotIndex);
    }

    public int getCharmCount(ItemStack belt) {
        CompoundTag nbt = belt.m_41783_();
        if (nbt == null) {
            return 0;
        }
        ListTag mobCharms = nbt.m_128437_(SLOTS_TAG, 10);
        return mobCharms.size();
    }

    public boolean hasCharm(ItemStack belt, String entityRegistryName) {
        CompoundTag nbt = belt.m_41783_();
        if (nbt == null || !nbt.m_128441_(SLOTS_TAG)) {
            return false;
        }
        ListTag mobCharms = nbt.m_128437_(SLOTS_TAG, 10);
        for (int i = mobCharms.size() - 1; i >= 0; --i) {
            ItemStack charmStack = ItemStack.m_41712_((CompoundTag)mobCharms.m_128728_(i));
            if (!MobCharmItem.getEntityRegistryName(charmStack).equals(entityRegistryName)) continue;
            return true;
        }
        return false;
    }

    ItemStack damageCharm(Player player, ItemStack belt, String entityRegistryName) {
        CompoundTag nbt = belt.m_41783_();
        if (nbt == null || !nbt.m_128441_(SLOTS_TAG)) {
            return ItemStack.f_41583_;
        }
        ListTag mobCharms = nbt.m_128437_(SLOTS_TAG, 10);
        for (int i = mobCharms.size() - 1; i >= 0; --i) {
            ItemStack charmStack = ItemStack.m_41712_((CompoundTag)mobCharms.m_128728_(i));
            if (!MobCharmItem.isCharmFor(charmStack, entityRegistryName)) continue;
            charmStack.m_41622_(((Integer)Settings.COMMON.items.mobCharm.damagePerKill.get()).intValue(), (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.CHEST));
            if (charmStack.m_41619_()) {
                this.removeMobCharmInSlot(belt, i);
                return ItemStack.f_41583_;
            }
            mobCharms.set(i, (Tag)charmStack.m_41739_(new CompoundTag()));
            return charmStack;
        }
        return ItemStack.f_41583_;
    }

    public Set<String> getCharmRegistryNames(ItemStack slotStack) {
        HashSet<String> ret = new HashSet<String>();
        ListTag mobCharms = slotStack.m_41784_().m_128437_(SLOTS_TAG, 10);
        for (int i = 0; i < mobCharms.size(); ++i) {
            ItemStack charmStack = ItemStack.m_41712_((CompoundTag)mobCharms.m_128728_(i));
            ret.add(MobCharmItem.getEntityRegistryName(charmStack));
        }
        return ret;
    }
}

