/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler.mode;

import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ModePlane {
    public static void invoke(Set<BlockPos> coordinates, int range, Level world, Direction sideHit, BlockPos pos, BlockState centerState) {
        ArrayList<BlockPos> possibleLocs = new ArrayList<BlockPos>();
        possibleLocs.add(pos);
        int index = 0;
        do {
            BlockPos currentPos = (BlockPos)possibleLocs.get(index);
            ExchangerHandler.checkAndAddBlock(world, currentPos, centerState, coordinates);
            switch (sideHit) {
                case UP: {
                    ModePlane.getConnectedBlocksUD(possibleLocs, world, currentPos, pos, centerState, range, true);
                    break;
                }
                case DOWN: {
                    ModePlane.getConnectedBlocksUD(possibleLocs, world, currentPos, pos, centerState, range, false);
                    break;
                }
                case SOUTH: {
                    ModePlane.getConnectedBlocksNS(possibleLocs, world, currentPos, pos, centerState, range, true);
                    break;
                }
                case NORTH: {
                    ModePlane.getConnectedBlocksNS(possibleLocs, world, currentPos, pos, centerState, range, false);
                    break;
                }
                case EAST: {
                    ModePlane.getConnectedBlocksEW(possibleLocs, world, currentPos, pos, centerState, range, true);
                    break;
                }
                case WEST: {
                    ModePlane.getConnectedBlocksEW(possibleLocs, world, currentPos, pos, centerState, range, false);
                }
            }
        } while (++index < possibleLocs.size());
    }

    public static MutableComponent getDisplayName() {
        return StringHelper.localize((String)"exchangers", (String)"mode.plane", (Object[])new Object[0]);
    }

    private static void getConnectedBlocksUD(List<BlockPos> possibleLocs, Level world, BlockPos currentPos, BlockPos centerPos, BlockState centerState, int range, boolean side) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos newPos = currentPos.m_7918_(x, 0, y);
                if (ModePlane.isLocationContained(possibleLocs, newPos) || newPos.m_123341_() > centerPos.m_123341_() + range || newPos.m_123341_() < centerPos.m_123341_() - range || newPos.m_123343_() > centerPos.m_123343_() + range || newPos.m_123343_() < centerPos.m_123343_() - range || world.m_8055_(newPos.m_7918_(0, side ? 1 : -1, 0)).m_60815_() || !ModePlane.checkBlock(world, newPos, centerState)) continue;
                possibleLocs.add(newPos);
            }
        }
    }

    private static void getConnectedBlocksNS(List<BlockPos> possibleLocs, Level world, BlockPos currentPos, BlockPos centerPos, BlockState centerState, int range, boolean side) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos newPos = currentPos.m_7918_(x, y, 0);
                if (ModePlane.isLocationContained(possibleLocs, newPos) || newPos.m_123341_() > centerPos.m_123341_() + range || newPos.m_123341_() < centerPos.m_123341_() - range || newPos.m_123342_() > centerPos.m_123342_() + range || newPos.m_123342_() < centerPos.m_123342_() - range || world.m_8055_(newPos.m_7918_(0, 0, side ? 1 : -1)).m_60815_() || !ModePlane.checkBlock(world, newPos, centerState)) continue;
                possibleLocs.add(newPos);
            }
        }
    }

    private static void getConnectedBlocksEW(List<BlockPos> possibleLocs, Level world, BlockPos currentPos, BlockPos centerPos, BlockState centerState, int range, boolean side) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos newPos = currentPos.m_7918_(0, x, y);
                if (ModePlane.isLocationContained(possibleLocs, newPos) || newPos.m_123342_() > centerPos.m_123342_() + range || newPos.m_123342_() < centerPos.m_123342_() - range || newPos.m_123343_() > centerPos.m_123343_() + range || newPos.m_123343_() < centerPos.m_123343_() - range || world.m_8055_(newPos.m_7918_(side ? 1 : -1, 0, 0)).m_60815_() || !ModePlane.checkBlock(world, newPos, centerState)) continue;
                possibleLocs.add(newPos);
            }
        }
    }

    private static boolean isLocationContained(List<BlockPos> possibleLocs, BlockPos toFind) {
        for (BlockPos pos : possibleLocs) {
            if (pos.m_123341_() != toFind.m_123341_() || pos.m_123342_() != toFind.m_123342_() || pos.m_123343_() != toFind.m_123343_()) continue;
            return true;
        }
        return false;
    }

    private static boolean checkBlock(Level world, BlockPos pos, BlockState centerState) {
        BlockState state = world.m_8055_(pos);
        return state == centerState;
    }
}

