/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import java.util.Optional;
import java.util.stream.IntStream;
import mods.railcraft.sounds.RailcraftSoundEvents;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.level.block.entity.SteamOvenBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.CrafterModule;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class SteamOvenModule
extends CrafterModule<SteamOvenBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 9;
    private static final int STEAM_PER_STEP = 500;
    private static final int TOTAL_COOK_TIME = 256;
    private static final int ITEMS_SMELTED = 9;
    protected final StandardTank steamTank = StandardTank.ofBuckets(8).filter(RailcraftTags.Fluids.STEAM);
    private final ContainerMapper inputContainer = ContainerMapper.make(this, 0, 9);
    private final ContainerMapper outputContainer = ContainerMapper.make(this, 9, 9).ignoreItemChecks();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper(this){

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < 9) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot >= 9) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    });
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.steamTank);

    public SteamOvenModule(SteamOvenBlockEntity provider) {
        super(provider, 18);
    }

    @Override
    protected boolean lacksRequirements() {
        return IntStream.range(0, this.inputContainer.m_6643_()).mapToObj(this.inputContainer::m_8020_).noneMatch(stack -> this.getRecipe((ItemStack)stack).isPresent());
    }

    private Optional<SmeltingRecipe> getRecipe(ItemStack itemStack) {
        return ((SteamOvenBlockEntity)this.provider).m_58904_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), ((SteamOvenBlockEntity)this.provider).m_58904_());
    }

    @Override
    protected int calculateDuration() {
        return 256;
    }

    @Override
    protected boolean doProcessStep() {
        if (!this.needFuel()) {
            this.steamTank.drain(500, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    private boolean needFuel() {
        FluidStack steam = this.steamTank.drain(500, IFluidHandler.FluidAction.SIMULATE);
        return steam.getAmount() < 500;
    }

    @Override
    protected boolean craftAndPush() {
        int count = 0;
        boolean changed = true;
        boolean smelted = false;
        RegistryAccess registryAccess = ((SteamOvenBlockEntity)this.provider).m_58904_().m_9598_();
        while (count < 9 && changed) {
            changed = false;
            for (int slot = 0; slot < 9 && count < 9; ++slot) {
                ItemStack output;
                ItemStack stack = this.inputContainer.m_8020_(slot);
                if (stack.m_41619_() || (output = this.getRecipe(stack).map(x -> x.m_8043_(registryAccess)).orElse(ItemStack.f_41583_)).m_41619_() || !this.outputContainer.canFit(output) || !this.outputContainer.insert(output).m_41619_()) continue;
                this.inputContainer.m_7407_(slot, 1);
                changed = true;
                ++count;
            }
            smelted |= changed;
        }
        if (smelted) {
            ((SteamOvenBlockEntity)this.provider).m_58904_().m_5594_(null, ((SteamOvenBlockEntity)this.provider).blockPos(), (SoundEvent)RailcraftSoundEvents.STEAM_BURST.get(), SoundSource.BLOCKS, 1.0f, ((SteamOvenBlockEntity)this.provider).m_58904_().m_213780_().m_188501_() * 0.1f + 1.0f);
        }
        return smelted;
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        if (index < 9 && super.m_7013_(index, stack)) {
            return this.getRecipe(stack).isPresent();
        }
        return super.m_7013_(index, stack);
    }

    public StandardTank getSteamTank() {
        return this.steamTank;
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    public void invalidItemHandler() {
        this.itemHandler.invalidate();
        this.fluidHandler.invalidate();
    }
}

