/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.inventory.DumpingTrackMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class DumpingTrackBlockEntity
extends RailcraftBlockEntity
implements MenuProvider {
    private static final int ITEM_DROP_INTERVAL = 16;
    private static final List<Direction> DIRECTION = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN);
    private final AdvancedContainer cartFilter = new AdvancedContainer(3).listener(x -> this.m_6596_()).phantom();
    private final AdvancedContainer itemFilter = new AdvancedContainer(9).listener(x -> this.m_6596_()).phantom();
    private final Predicate<ItemStack> itemMatcher = StackFilter.anyMatch(this.itemFilter);
    private int ticksSinceLastDrop = 0;

    public DumpingTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.DUMPING_TRACK.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, DumpingTrackBlockEntity blockEntity) {
        ++blockEntity.ticksSinceLastDrop;
    }

    @Nullable
    private static BlockEntity getBlockEntityAround(Level level, BlockPos pos) {
        for (Direction direction : DIRECTION) {
            BlockEntity blockEntity = level.m_7702_(pos.m_121945_(direction));
            if (blockEntity == null || !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) continue;
            return blockEntity;
        }
        return null;
    }

    public AdvancedContainer getCartFilter() {
        return this.cartFilter;
    }

    public AdvancedContainer getItemFilter() {
        return this.itemFilter;
    }

    public void minecartPassed(AbstractMinecart cart, boolean powered) {
        boolean sameCart;
        if (powered) {
            return;
        }
        if (!this.cartFilter.m_7983_() && !(sameCart = this.cartFilter.stream().anyMatch(slot -> slot.is(cart.m_142340_().m_41720_())))) {
            return;
        }
        if (!cart.m_20197_().isEmpty() && this.tryDumpRider(cart)) {
            return;
        }
        this.tryDumpInventory(cart);
    }

    private boolean tryDumpRider(AbstractMinecart cart) {
        MinecartUtil.removePassengers(cart);
        return true;
    }

    private void tryDumpInventory(AbstractMinecart cart) {
        if (this.ticksSinceLastDrop < 16) {
            return;
        }
        cart.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            ContainerManipulator<SlotAccessor> cartInv = ContainerManipulator.of(itemHandler);
            if (!cartInv.hasItems()) {
                return;
            }
            this.ticksSinceLastDrop = 0;
            BlockEntity blockEntity = DumpingTrackBlockEntity.getBlockEntityAround(this.f_58857_, this.blockPos());
            if (blockEntity == null) {
                BlockPos below = this.blockPos().m_7495_();
                if (this.itemFilter.m_7983_()) {
                    cartInv.streamItems().forEach(itemStack -> Containers.m_18992_((Level)this.f_58857_, (double)below.m_123341_(), (double)below.m_123342_(), (double)below.m_123343_(), (ItemStack)itemStack));
                } else {
                    cartInv.streamItems().filter(this.itemMatcher).forEach(itemStack -> Containers.m_18992_((Level)this.f_58857_, (double)below.m_123341_(), (double)below.m_123342_(), (double)below.m_123343_(), (ItemStack)itemStack));
                }
                return;
            }
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandlerBlockEntity -> {
                ContainerManipulator<SlotAccessor> blockInv = ContainerManipulator.of(itemHandlerBlockEntity);
                cartInv.moveOneItemStackTo(blockInv);
            });
        });
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("cartFilter", (Tag)this.cartFilter.m_7927_());
        tag.m_128365_("itemFilter", (Tag)this.itemFilter.m_7927_());
        tag.m_128405_("ticksSinceLastDrop", this.ticksSinceLastDrop);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cartFilter.m_7797_(tag.m_128437_("cartFilter", 10));
        this.itemFilter.m_7797_(tag.m_128437_("itemFilter", 10));
        this.ticksSinceLastDrop = tag.m_128451_("ticksSinceLastDrop");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new DumpingTrackMenu(id, inventory, this);
    }
}

