/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle.locomotive;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.api.carts.Linkable;
import mods.railcraft.api.carts.NeedsFuel;
import mods.railcraft.api.carts.Paintable;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Routable;
import mods.railcraft.api.core.Lockable;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.SimpleTexturePosition;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.gui.button.ButtonState;
import mods.railcraft.network.RailcraftDataSerializers;
import mods.railcraft.season.Seasons;
import mods.railcraft.util.FunctionalUtil;
import mods.railcraft.util.MathUtil;
import mods.railcraft.util.ModEntitySelector;
import mods.railcraft.util.PlayerUtil;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.damagesource.RailcraftDamageSources;
import mods.railcraft.world.entity.vehicle.Directional;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import mods.railcraft.world.item.LocomotiveItem;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.TicketItem;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class Locomotive
extends RailcraftMinecart
implements Linkable,
Directional,
Lockable,
Paintable,
Routable,
NeedsFuel {
    private static final EntityDataAccessor<Boolean> HAS_FUEL = SynchedEntityData.m_135353_(Locomotive.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Mode> MODE = SynchedEntityData.m_135353_(Locomotive.class, RailcraftDataSerializers.LOCOMOTIVE_MODE);
    private static final EntityDataAccessor<Speed> SPEED = SynchedEntityData.m_135353_(Locomotive.class, RailcraftDataSerializers.LOCOMOTIVE_SPEED);
    private static final EntityDataAccessor<Lock> LOCK = SynchedEntityData.m_135353_(Locomotive.class, RailcraftDataSerializers.LOCOMOTIVE_LOCK);
    private static final EntityDataAccessor<Boolean> REVERSE = SynchedEntityData.m_135353_(Locomotive.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PRIMARY_COLOR = SynchedEntityData.m_135353_(Locomotive.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SECONDARY_COLOR = SynchedEntityData.m_135353_(Locomotive.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DESTINATION = SynchedEntityData.m_135353_(Locomotive.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Optional<GameProfile>> OWNER = SynchedEntityData.m_135353_(Locomotive.class, RailcraftDataSerializers.OPTIONAL_GAME_PROFILE);
    private static final double DRAG_FACTOR = 0.9;
    private static final float HS_FORCE_BONUS = 3.5f;
    private static final byte FUEL_USE_INTERVAL = 8;
    private static final byte KNOCKBACK = 1;
    private static final int WHISTLE_INTERVAL = 256;
    private static final int WHISTLE_DELAY = 160;
    private static final int WHISTLE_CHANCE = 4;
    private static final Set<Mode> SUPPORTED_MODES = Collections.unmodifiableSet(EnumSet.allOf(Mode.class));
    protected float renderYaw;
    private int fuel;
    private int whistleDelay;
    private int tempIdle;
    private float whistlePitch = this.getNewWhistlePitch();

    protected Locomotive(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected Locomotive(ItemStack itemStack, EntityType<?> type, double x, double y, double z, ServerLevel level) {
        super(itemStack, type, x, y, z, (Level)level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_FUEL, (Object)false);
        this.f_19804_.m_135372_(PRIMARY_COLOR, (Object)this.getDefaultPrimaryColor().m_41060_());
        this.f_19804_.m_135372_(SECONDARY_COLOR, (Object)this.getDefaultSecondaryColor().m_41060_());
        this.f_19804_.m_135372_(MODE, (Object)Mode.SHUTDOWN);
        this.f_19804_.m_135372_(SPEED, (Object)Speed.NORMAL);
        this.f_19804_.m_135372_(LOCK, (Object)Lock.UNLOCKED);
        this.f_19804_.m_135372_(REVERSE, (Object)false);
        this.f_19804_.m_135372_(DESTINATION, (Object)"");
        this.f_19804_.m_135372_(OWNER, Optional.empty());
    }

    protected DyeColor getDefaultPrimaryColor() {
        return DyeColor.PURPLE;
    }

    protected DyeColor getDefaultSecondaryColor() {
        return DyeColor.BLACK;
    }

    @Override
    protected void loadFromItemStack(ItemStack itemStack) {
        super.loadFromItemStack(itemStack);
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null || !(itemStack.m_41720_() instanceof LocomotiveItem)) {
            return;
        }
        this.setPrimaryColor(LocomotiveItem.getPrimaryColor(itemStack));
        this.setSecondaryColor(LocomotiveItem.getSecondaryColor(itemStack));
        if (tag.m_128441_("whistlePitch")) {
            this.whistlePitch = tag.m_128457_("whistlePitch");
        }
        if (tag.m_128425_("owner", 10)) {
            GameProfile ownerProfile = NbtUtils.m_129228_((CompoundTag)tag.m_128469_("owner"));
            this.setOwner(ownerProfile);
            this.setLock(Lock.LOCKED);
        }
        if (tag.m_128425_("lock", 8)) {
            Lock.fromNameOptional(tag.m_128461_("lock")).ifPresent(this::setLock);
        }
    }

    @Override
    public Optional<GameProfile> getOwner() {
        return (Optional)this.f_19804_.m_135370_(OWNER);
    }

    @Override
    public void setOwner(@Nullable GameProfile owner) {
        if (owner != null && !owner.isComplete()) {
            String ownerName = "[unknown]";
            if (!StringUtils.isBlank((CharSequence)owner.getName())) {
                ownerName = owner.getName();
            }
            owner = new GameProfile(owner.getId(), ownerName);
        }
        this.f_19804_.m_135381_(OWNER, Optional.ofNullable(owner));
    }

    private float getNewWhistlePitch() {
        return 1.0f + (float)this.f_19796_.m_188583_() * 0.2f;
    }

    @Override
    public ItemStack m_142340_() {
        ItemStack itemStack = this.m_213728_().m_7968_();
        if (this.isLocked()) {
            LocomotiveItem.setOwnerData(itemStack, this.getOwnerOrThrow());
        }
        LocomotiveItem.setItemColorData(itemStack, this.getPrimaryDyeColor(), this.getSecondaryDyeColor());
        LocomotiveItem.setItemWhistleData(itemStack, this.whistlePitch);
        if (this.m_8077_()) {
            itemStack.m_41714_(this.m_7770_());
        }
        return itemStack;
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_41619_() && itemStack.m_150930_((Item)RailcraftItems.WHISTLE_TUNER.get())) {
            if (this.whistleDelay <= 0) {
                this.whistlePitch = this.getNewWhistlePitch();
                this.whistle();
                itemStack.m_41622_(1, (LivingEntity)((ServerPlayer)player), serverPlayerEntity -> player.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.canControl(player)) {
            return super.m_6096_(player, hand);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    @Override
    public boolean isLocked() {
        return this.getLock() == Lock.LOCKED || this.isPrivate();
    }

    public boolean isPrivate() {
        return this.getLock() == Lock.PRIVATE;
    }

    public boolean canControl(Player player) {
        return !this.isPrivate() || PlayerUtil.isOwnerOrOp(this.getOwner().orElseThrow(() -> new IllegalStateException("Locomotive is private but has no owner.")), player);
    }

    public Lock getLock() {
        return (Lock)this.f_19804_.m_135370_(LOCK);
    }

    public void setLock(Lock lock) {
        this.f_19804_.m_135381_(LOCK, (Object)lock);
    }

    @Override
    public String getDestination() {
        return (String)this.f_19804_.m_135370_(DESTINATION);
    }

    public void setDestination(String destination) {
        this.f_19804_.m_135381_(DESTINATION, (Object)destination);
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (ticket.m_41720_() instanceof TicketItem) {
            String destination;
            if (this.isLocked()) {
                GameProfile ticketOwner = TicketItem.getOwner(ticket);
                if (ticketOwner == null) {
                    return false;
                }
                if (!this.getOwnerOrThrow().equals((Object)ticketOwner) && !serverLevel.m_7654_().m_6846_().m_11303_(ticketOwner)) {
                    return false;
                }
            }
            if (!(destination = TicketItem.getDestination(ticket)).equals(this.getDestination())) {
                this.setDestination(destination);
                this.ticketContainer().m_6836_(1, TicketItem.copyTicket(ticket));
                return true;
            }
        }
        return false;
    }

    public Mode getMode() {
        return (Mode)((Object)this.f_19804_.m_135370_(MODE));
    }

    public void setMode(Mode mode) {
        if (!this.isAllowedMode(mode)) {
            return;
        }
        this.f_19804_.m_135381_(MODE, (Object)mode);
    }

    public Set<Mode> getSupportedModes() {
        return SUPPORTED_MODES;
    }

    public boolean isAllowedMode(Mode mode) {
        return this.getSupportedModes().contains((Object)mode);
    }

    public Speed getSpeed() {
        return (Speed)((Object)this.f_19804_.m_135370_(SPEED));
    }

    public void setSpeed(Speed speed) {
        if (this.isReverse() && speed.getLevel() > this.getMaxReverseSpeed().getLevel()) {
            return;
        }
        this.f_19804_.m_135381_(SPEED, (Object)speed);
    }

    public Speed getMaxReverseSpeed() {
        return Speed.NORMAL;
    }

    public void increaseSpeed() {
        this.setSpeed(this.getSpeed().shiftUp());
    }

    public void decreaseSpeed() {
        this.setSpeed(this.getSpeed().shiftDown());
    }

    public boolean hasFuel() {
        return (Boolean)this.f_19804_.m_135370_(HAS_FUEL);
    }

    public void setHasFuel(boolean hasFuel) {
        this.f_19804_.m_135381_(HAS_FUEL, (Object)hasFuel);
    }

    public boolean isReverse() {
        return (Boolean)this.f_19804_.m_135370_(REVERSE);
    }

    public void setReverse(boolean reverse) {
        this.f_19804_.m_135381_(REVERSE, (Object)reverse);
    }

    public boolean isRunning() {
        return this.hasFuel() && this.getMode() == Mode.RUNNING && !this.isIdle() && !this.isShutdown();
    }

    public boolean isIdle() {
        return !this.isShutdown() && (this.tempIdle > 0 || this.getMode() == Mode.IDLE || !this.m_9236_().m_5776_() && RollingStock.getOrThrow((AbstractMinecart)this).train().isIdle());
    }

    public boolean isShutdown() {
        return this.getMode() == Mode.SHUTDOWN || !this.m_9236_().m_5776_() && RollingStock.getOrThrow((AbstractMinecart)this).train().state().isStopped();
    }

    public void forceIdle(int ticks) {
        this.tempIdle = Math.max(this.tempIdle, ticks);
    }

    @Override
    public void reverse() {
        this.m_146922_(this.m_146908_() + 180.0f);
        this.m_20256_(this.m_20184_().m_82542_(-1.0, 1.0, -1.0));
    }

    @Override
    public void setRenderYaw(float yaw) {
        this.renderYaw = yaw;
    }

    public abstract SoundEvent getWhistleSound();

    public final void whistle() {
        if (this.whistleDelay <= 0) {
            this.m_9236_().m_6269_(null, (Entity)this, this.getWhistleSound(), this.m_5720_(), 1.0f, this.whistlePitch);
            this.whistleDelay = 160;
        }
    }

    public final void m_8119_() {
        super.m_8119_();
        if (this.m_213877_()) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            this.clientTick(this.m_9236_());
        } else {
            ServerLevel serverLevel = (ServerLevel)level;
            this.serverTick(serverLevel);
        }
    }

    protected void serverTick(ServerLevel level) {
        this.processTicket();
        this.updateFuel();
        if (this.whistleDelay > 0) {
            --this.whistleDelay;
        }
        if (this.tempIdle > 0) {
            --this.tempIdle;
        }
        if (this.f_19797_ % 256 == 0 && this.isRunning() && this.f_19796_.m_188503_(4) == 0) {
            this.whistle();
        }
    }

    protected void clientTick(Level level) {
        if (!(!Seasons.isPolarExpress((AbstractMinecart)this) || MathUtil.nearZero(this.m_20184_().m_7096_()) && MathUtil.nearZero(this.m_20184_().m_7094_()))) {
            this.snowEffect(this.m_20185_(), this.m_20191_().f_82289_ - this.m_20186_(), this.m_20189_());
        }
    }

    private void snowEffect(double x, double y, double z) {
        double vx = this.f_19796_.m_188583_() * 0.1;
        double vy = this.f_19796_.m_188500_() * 0.01;
        double vz = this.f_19796_.m_188583_() * 0.1;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123754_, x, y, z, vx, vy, vz);
    }

    protected abstract Container ticketContainer();

    private void processTicket() {
        Container ticketContainer = this.ticketContainer();
        ItemStack ticketStack = ticketContainer.m_8020_(0);
        if (ticketStack.m_41720_() instanceof TicketItem) {
            if (this.setDestination(ticketStack)) {
                ticketContainer.m_6836_(0, ContainerTools.depleteItem(ticketStack));
            }
            return;
        }
        ticketContainer.m_6836_(0, ItemStack.f_41583_);
    }

    protected void m_7114_() {
        if (this.m_213877_()) {
            return;
        }
        this.m_20256_(this.m_20184_().m_82542_(this.getDrag(), 0.0, this.getDrag()));
        if (this.isReverse() && this.getSpeed().getLevel() > this.getMaxReverseSpeed().getLevel()) {
            this.setSpeed(this.getMaxReverseSpeed());
        }
        Speed speed = this.getSpeed();
        if (this.isRunning()) {
            double force = (Double)RailcraftConfig.SERVER.locomotiveHorsepower.get() * (double)0.01f;
            if (this.isReverse()) {
                force = -force;
            }
            if (speed.equals((Object)Speed.MAX) && RollingStock.getOrThrow((AbstractMinecart)this).isHighSpeed()) {
                force *= 3.5;
            }
            double yaw = this.m_146908_() * ((float)Math.PI / 180);
            this.m_20256_(this.m_20184_().m_82520_(Math.cos(yaw) * force, 0.0, Math.sin(yaw) * force));
        }
        if (speed != Speed.MAX) {
            float limit = switch (speed) {
                case Speed.SLOWEST -> 0.1f;
                case Speed.SLOWER -> 0.2f;
                case Speed.NORMAL -> 0.3f;
                default -> 0.4f;
            };
            Vec3 motion = this.m_20184_();
            this.m_20334_(Math.copySign(Math.min(Math.abs(motion.m_7096_()), (double)limit), motion.m_7096_()), motion.m_7098_(), Math.copySign(Math.min(Math.abs(motion.m_7094_()), (double)limit), motion.m_7094_()));
        }
    }

    private int getFuelUse() {
        if (this.isRunning()) {
            return switch (this.getSpeed()) {
                case Speed.SLOWEST -> 2;
                case Speed.SLOWER -> 4;
                case Speed.NORMAL -> 6;
                default -> 8;
            };
        }
        if (this.isIdle()) {
            return this.getIdleFuelUse();
        }
        return 0;
    }

    protected int getIdleFuelUse() {
        return 1;
    }

    protected void updateFuel() {
        int newFuel;
        if (this.f_19797_ % 8 == 0 && this.fuel > 0) {
            this.fuel -= this.getFuelUse();
            if (this.fuel < 0) {
                this.fuel = 0;
            }
        }
        while (this.fuel <= 8 && !this.isShutdown() && (newFuel = this.retrieveFuel()) > 0) {
            this.fuel += newFuel;
        }
        this.setHasFuel(this.fuel > 0);
    }

    protected abstract int retrieveFuel();

    private int getDamageToRoadKill(LivingEntity entity) {
        ItemStack pants;
        if (entity instanceof Player && (pants = entity.m_6844_(EquipmentSlot.LEGS)).m_150930_((Item)RailcraftItems.OVERALLS.get())) {
            pants.m_41622_(5, entity, unusedThing -> entity.m_21166_(EquipmentSlot.LEGS));
            return 4;
        }
        return 25;
    }

    public void m_7334_(Entity entity) {
        if (!this.m_9236_().m_5776_()) {
            if (!entity.m_6084_()) {
                return;
            }
            RollingStock extension = RollingStock.getOrThrow((AbstractMinecart)this);
            if (extension.train().entities().noneMatch(t -> t.m_20363_(entity)) && (this.isVelocityHigherThan(0.2f) || extension.isHighSpeed()) && ModEntitySelector.KILLABLE.test(entity)) {
                LivingEntity living = (LivingEntity)entity;
                if (((Boolean)RailcraftConfig.SERVER.locomotiveDamageMobs.get()).booleanValue()) {
                    living.m_6469_((DamageSource)RailcraftDamageSources.train(this.m_9236_().m_9598_()), (float)this.getDamageToRoadKill(living));
                }
                if (living.m_21223_() > 0.0f) {
                    float yaw = (this.m_146908_() - 90.0f) * ((float)Math.PI / 180);
                    this.m_20256_(this.m_20184_().m_82520_((double)(-Mth.m_14031_((float)yaw) * 1.0f * 0.5f), 0.2, (double)(Mth.m_14089_((float)yaw) * 1.0f * 0.5f)));
                } else if (living instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)living;
                    RailcraftCriteriaTriggers.KILLED_BY_LOCOMOTIVE.trigger(serverPlayer, (AbstractMinecart)this);
                }
                return;
            }
            if (this.collidedWithOtherLocomotive(entity)) {
                Locomotive otherLoco = (Locomotive)entity;
                this.explode();
                if (otherLoco.m_6084_()) {
                    otherLoco.explode();
                }
                return;
            }
        }
        super.m_7334_(entity);
    }

    private boolean collidedWithOtherLocomotive(Entity entity) {
        if (!(entity instanceof Locomotive)) {
            return false;
        }
        Locomotive otherLoco = (Locomotive)entity;
        if (this.m_20148_().equals(entity.m_20148_())) {
            return false;
        }
        if (RollingStock.getOrThrow((AbstractMinecart)this).isSameTrainAs(RollingStock.getOrThrow((AbstractMinecart)otherLoco))) {
            return false;
        }
        Vec3 motion = this.m_20184_();
        Vec3 otherMotion = entity.m_20184_();
        return this.isVelocityHigherThan(0.2f) && otherLoco.isVelocityHigherThan(0.2f) && (Math.abs(motion.m_7096_() - otherMotion.m_7096_()) > (double)0.3f || Math.abs(motion.m_7094_() - otherMotion.m_7094_()) > (double)0.3f);
    }

    private boolean isVelocityHigherThan(float velocity) {
        return Math.abs(this.m_20184_().m_7096_()) > (double)velocity || Math.abs(this.m_20184_().m_7094_()) > (double)velocity;
    }

    @Override
    public void m_142687_(Entity.RemovalReason reason) {
        this.ticketContainer().m_6836_(1, ItemStack.f_41583_);
        super.m_142687_(reason);
    }

    public void explode() {
        MinecartUtil.explodeCart((AbstractMinecart)this);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public double getDrag() {
        return 0.9;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("flipped", this.f_38068_);
        tag.m_128359_("dest", (String)StringUtils.defaultIfBlank((CharSequence)this.getDestination(), (CharSequence)""));
        tag.m_128359_("mode", this.getMode().m_7912_());
        tag.m_128359_("speed", this.getSpeed().m_7912_());
        tag.m_128359_("lock", this.getLock().m_7912_());
        tag.m_128359_("primaryColor", DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(PRIMARY_COLOR))).m_7912_());
        tag.m_128359_("secondaryColor", DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(SECONDARY_COLOR))).m_7912_());
        tag.m_128350_("whistlePitch", this.whistlePitch);
        tag.m_128405_("fuel", this.fuel);
        tag.m_128379_("reverse", this.isReverse());
        this.getOwner().ifPresent(owner -> tag.m_128365_("owner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)owner)));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_38068_ = tag.m_128471_("flipped");
        this.setDestination(tag.m_128461_("dest"));
        this.setMode(Mode.fromName(tag.m_128461_("mode")));
        this.setSpeed(Speed.fromName(tag.m_128461_("speed")));
        this.setLock(Lock.fromName(tag.m_128461_("lock")));
        this.setPrimaryColor(DyeColor.m_41057_((String)tag.m_128461_("primaryColor"), (DyeColor)this.getDefaultPrimaryColor()));
        this.setSecondaryColor(DyeColor.m_41057_((String)tag.m_128461_("secondaryColor"), (DyeColor)this.getDefaultSecondaryColor()));
        this.whistlePitch = tag.m_128457_("whistlePitch");
        this.fuel = tag.m_128451_("fuel");
        if (tag.m_128425_("reverse", 1)) {
            this.f_19804_.m_135381_(REVERSE, (Object)tag.m_128471_("reverse"));
        }
        if (tag.m_128425_("owner", 10)) {
            this.setOwner(NbtUtils.m_129228_((CompoundTag)tag.m_128469_("owner")));
        } else {
            this.setOwner(null);
        }
    }

    public void applyAction(Player player, boolean single, Consumer<Locomotive> action) {
        Stream<Locomotive> locos = RollingStock.getOrThrow((AbstractMinecart)this).train().entities().flatMap(FunctionalUtil.ofType(Locomotive.class)).filter(loco -> loco.canControl(player));
        if (single) {
            locos.findAny().ifPresent(action);
        } else {
            locos.forEach(action);
        }
    }

    @Override
    public boolean canBeRidden() {
        return false;
    }

    public int m_6643_() {
        return 0;
    }

    @Override
    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public float getOptimalDistance(RollingStock cart) {
        return 0.9f;
    }

    @Override
    public void linked(RollingStock cart) {
        if (this.getSpeed().compareTo(Speed.SLOWEST) > 0) {
            this.setSpeed(Speed.SLOWEST);
        }
    }

    @Override
    public boolean canPassItemRequests(ItemStack stack) {
        return true;
    }

    @Override
    public final DyeColor getPrimaryDyeColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(PRIMARY_COLOR)));
    }

    public final void setPrimaryColor(DyeColor color) {
        this.f_19804_.m_135381_(PRIMARY_COLOR, (Object)color.m_41060_());
    }

    @Override
    public final DyeColor getSecondaryDyeColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(SECONDARY_COLOR)));
    }

    public final void setSecondaryColor(DyeColor color) {
        this.f_19804_.m_135381_(SECONDARY_COLOR, (Object)color.m_41060_());
    }

    public static enum Mode implements StringRepresentable
    {
        SHUTDOWN(Translations.Screen.LOCOMOTIVE_MODE_SHUTDOWN),
        IDLE(Translations.Screen.LOCOMOTIVE_MODE_IDLE),
        RUNNING(Translations.Screen.LOCOMOTIVE_MODE_RUNNING);

        private static final StringRepresentable.EnumCodec<Mode> CODEC;
        private final String name;
        private final String translationKey;

        private Mode(String translationKey) {
            this.translationKey = translationKey;
            this.name = translationKey.substring(translationKey.lastIndexOf(46) + 1);
        }

        public Mode next() {
            return (Mode)EnumUtil.next((Enum)this, (Enum[])Mode.values());
        }

        public Mode previous() {
            return (Mode)EnumUtil.previous((Enum)this, (Enum[])Mode.values());
        }

        public String m_7912_() {
            return this.name;
        }

        public Component getDisplayName() {
            return Component.m_237115_((String)this.translationKey);
        }

        public static Mode fromName(String name) {
            return (Mode)CODEC.m_262792_(name, (Enum)IDLE);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Mode::values);
        }
    }

    public static enum Speed implements StringRepresentable
    {
        SLOWEST("slowest", 1, 1, 0),
        SLOWER("slower", 2, 1, -1),
        NORMAL("normal", 3, 1, -1),
        MAX("max", 4, 0, -1);

        private static final StringRepresentable.EnumCodec<Speed> CODEC;
        private final String name;
        private final int shiftUp;
        private final int shiftDown;
        private final int level;

        private Speed(String name, int level, int shiftUp, int shiftDown) {
            this.name = name;
            this.level = level;
            this.shiftUp = shiftUp;
            this.shiftDown = shiftDown;
        }

        public int getLevel() {
            return this.level;
        }

        public String m_7912_() {
            return this.name;
        }

        public Speed shiftUp() {
            return Speed.values()[this.ordinal() + this.shiftUp];
        }

        public Speed shiftDown() {
            return Speed.values()[this.ordinal() + this.shiftDown];
        }

        public static Speed fromName(String name) {
            return (Speed)CODEC.m_262792_(name, (Enum)NORMAL);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Speed::values);
        }
    }

    public static enum Lock implements ButtonState<Lock>,
    StringRepresentable
    {
        UNLOCKED("unlocked", ButtonTexture.UNLOCKED_BUTTON),
        LOCKED("locked", ButtonTexture.LOCKED_BUTTON),
        PRIVATE("private", new SimpleTexturePosition(240, 48, 16, 16));

        private static final StringRepresentable.EnumCodec<Lock> CODEC;
        private final String name;
        private final TexturePosition texture;

        private Lock(String name, TexturePosition texture) {
            this.name = name;
            this.texture = texture;
        }

        @Override
        public Component label() {
            return Component.m_237119_();
        }

        @Override
        public TexturePosition texturePosition() {
            return this.texture;
        }

        @Override
        public Lock next() {
            return (Lock)EnumUtil.next((Enum)this, (Enum[])Lock.values());
        }

        public String m_7912_() {
            return this.name;
        }

        public static Lock fromName(String name) {
            return (Lock)CODEC.m_262792_(name, (Enum)UNLOCKED);
        }

        public static Optional<Lock> fromNameOptional(String name) {
            return Optional.ofNullable((Lock)CODEC.m_216455_(name));
        }

        static {
            CODEC = StringRepresentable.m_216439_(Lock::values);
        }
    }
}

