/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.function.Function;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.client.renderer.blockentity.SignalAuraRenderUtil;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public abstract class AbstractSignalRenderer<T extends AbstractSignalBlockEntity>
implements BlockEntityRenderer<T> {
    private static final Map<SignalAspect, ResourceLocation> ASPECT_TEXTURE_LOCATIONS = Map.of(SignalAspect.OFF, RailcraftConstants.rl("entity/signal_aspect/off"), SignalAspect.RED, RailcraftConstants.rl("entity/signal_aspect/red"), SignalAspect.YELLOW, RailcraftConstants.rl("entity/signal_aspect/yellow"), SignalAspect.GREEN, RailcraftConstants.rl("entity/signal_aspect/green"));
    private final CuboidModel signalAspectModel = new CuboidModel(1.0f);

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        SignalAuraRenderUtil.tryRenderSignalAura(blockEntity, poseStack, bufferSource);
        if (((RailcraftBlockEntity)blockEntity).m_8077_()) {
            RenderUtil.renderBlockHoverText(blockEntity.m_58899_(), ((RailcraftBlockEntity)blockEntity).m_7770_(), poseStack, bufferSource, packedLight);
        }
    }

    protected void renderSignalAspect(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, SignalAspect signalAspect, Direction direction) {
        Function spriteGetter = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        int skyLight = LightTexture.m_109894_((int)packedLight);
        packedLight = LightTexture.m_109885_((int)signalAspect.getLampLight(), (int)skyLight);
        this.signalAspectModel.clear();
        this.signalAspectModel.setPackedLight(packedLight);
        this.signalAspectModel.setPackedOverlay(packedOverlay);
        this.signalAspectModel.set(direction, new CuboidModel.Face(this.signalAspectModel).setSprite((TextureAtlasSprite)spriteGetter.apply(ASPECT_TEXTURE_LOCATIONS.get((Object)signalAspect))).setSize(16));
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)InventoryMenu.f_39692_));
        CuboidModelRenderer.render(this.signalAspectModel, poseStack, vertexConsumer, -1, CuboidModelRenderer.FaceDisplay.FRONT, false);
    }
}

